/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxgraph.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fx.ide.fxgraph.fXGraph.BindValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ComponentDefinition;
import org.eclipse.fx.ide.fxgraph.fXGraph.ConstValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ControllerHandledValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.CopyValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Define;
import org.eclipse.fx.ide.fxgraph.fXGraph.Element;
import org.eclipse.fx.ide.fxgraph.fXGraph.Import;
import org.eclipse.fx.ide.fxgraph.fXGraph.IncludeValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ListValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.LocationValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.MapValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.PackageDeclaration;
import org.eclipse.fx.ide.fxgraph.fXGraph.Property;
import org.eclipse.fx.ide.fxgraph.fXGraph.ReferenceValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ResourceValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Script;
import org.eclipse.fx.ide.fxgraph.fXGraph.ScriptHandlerHandledValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.SimpleValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticCallValueProperty;
import org.eclipse.fx.ide.ui.util.IconKeys;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;

public class FXGraphLabelProvider
extends DefaultEObjectLabelProvider {
    @Inject
    public FXGraphLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    String text(IncludeValueProperty element) {
        return element.getSource().getName();
    }

    Image image(IncludeValueProperty element) {
        return IconKeys.getIcon((String)IconKeys.INCLUDE_KEY);
    }

    Image image(StaticCallValueProperty element) {
        return IconKeys.getIcon((String)IconKeys.STAT_METHOD_PUBLIC_KEY);
    }

    String text(PackageDeclaration element) {
        return element.getName();
    }

    Image image(PackageDeclaration element) {
        return IconKeys.getIcon((String)IconKeys.PACKAGE_KEY);
    }

    String text(Import element) {
        return element.getImportedNamespace();
    }

    Image image(Import element) {
        return IconKeys.getIcon((String)IconKeys.IMPORT_KEY);
    }

    String text(ComponentDefinition def) {
        return String.valueOf(def.getName()) + def.getController() == null ? "" : " (" + def.getController().getSimpleName() + ")";
    }

    Image image(ComponentDefinition def) {
        return IconKeys.getIcon((String)IconKeys.COMPONENT_KEY);
    }

    String text(Element element) {
        return element.getType() != null ? element.getType().getSimpleName() : "<unknown>";
    }

    Image image(Element element) {
        return IconKeys.getIcon((String)IconKeys.CLASS_KEY);
    }

    Image image(Define element) {
        return IconKeys.getIcon((String)IconKeys.DEFINES_KEY);
    }

    Image image(Script script) {
        return IconKeys.getIcon((String)IconKeys.SCRIPTS_KEY);
    }

    Image image(Property element) {
        if (element.getValue() instanceof Element) {
            return IconKeys.getIcon((String)IconKeys.FIELD_KEY);
        }
        if (element.getValue() instanceof IncludeValueProperty) {
            return IconKeys.getIcon((String)IconKeys.INCLUDE_KEY);
        }
        if (element.getValue() instanceof ReferenceValueProperty) {
            return IconKeys.getIcon((String)IconKeys.REFERENCE_KEY);
        }
        if (element.getValue() instanceof ListValueProperty) {
            return IconKeys.getIcon((String)IconKeys.LIST_KEY);
        }
        if (element.getValue() instanceof MapValueProperty) {
            return IconKeys.getIcon((String)IconKeys.MAP_KEY);
        }
        if (element.getValue() instanceof BindValueProperty) {
            return IconKeys.getIcon((String)IconKeys.BINDING_KEY);
        }
        if (element.getValue() instanceof ControllerHandledValueProperty) {
            return IconKeys.getIcon((String)IconKeys.EVENT_KEY);
        }
        if (element.getValue() instanceof CopyValueProperty) {
            return IconKeys.getIcon((String)IconKeys.COPY_KEY);
        }
        if (element.getValue() instanceof LocationValueProperty) {
            return IconKeys.getIcon((String)IconKeys.LOCATION_KEY);
        }
        if (element.getValue() instanceof ResourceValueProperty) {
            return IconKeys.getIcon((String)IconKeys.EXTERNALIZED_STRING_KEY);
        }
        if (element.getValue() instanceof ScriptHandlerHandledValueProperty) {
            return IconKeys.getIcon((String)IconKeys.EVENT_KEY);
        }
        if (element.getValue() instanceof SimpleValueProperty) {
            return IconKeys.getIcon((String)IconKeys.FIELD_KEY);
        }
        if (element.getValue() instanceof ConstValueProperty) {
            return IconKeys.getIcon((String)IconKeys.FIELD_KEY);
        }
        return null;
    }
}

