/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.parts;

import java.util.List;
import org.eclipse.emf.eef.runtime.ui.parts.sequence.CompositionStep;
import org.eclipse.swt.widgets.Composite;

public abstract class PartComposer {
    private CompositionStep compositionSequence;

    public PartComposer(CompositionStep sequence) {
        this.compositionSequence = sequence;
    }

    public CompositionStep getCompositionSequence() {
        return this.compositionSequence;
    }

    public void compose(Composite parent) {
        List<CompositionStep> subSteps = this.compositionSequence.getSubSteps();
        if (!subSteps.isEmpty()) {
            for (CompositionStep compositionStep : subSteps) {
                this.composeDelegate(parent, compositionStep);
            }
        }
    }

    protected void composeDelegate(Composite parent, CompositionStep step) {
        if (step.isVisibile()) {
            Composite currentContainer = this.addToPart(parent, step.key);
            List<CompositionStep> subSteps = step.getSubSteps();
            if (!subSteps.isEmpty()) {
                for (CompositionStep compositionStep : subSteps) {
                    this.composeDelegate(currentContainer, compositionStep);
                }
            }
        }
    }

    public boolean isVisible(Object key) {
        if (this.compositionSequence != null) {
            return this.compositionSequence.isVisible(key);
        }
        return false;
    }

    public abstract Composite addToPart(Composite var1, Object var2);
}

