/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import org.jruby.lexer.yacc.LexState;
import org.jruby.parser.Tokens;

public class Keyword
implements Tokens {
    public String name;
    public int id0;
    public int id1;
    public LexState state;
    private static final int MIN_WORD_LENGTH = 2;
    private static final int MAX_WORD_LENGTH = 8;
    private static final int MIN_HASH_VALUE = 6;
    private static final int MAX_HASH_VALUE = 55;
    private static final byte[] asso_values = new byte[]{56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 11, 56, 56, 36, 56, 1, 37, 31, 1, 56, 56, 56, 56, 29, 56, 1, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 1, 56, 32, 1, 2, 1, 1, 4, 23, 56, 17, 56, 20, 9, 2, 9, 26, 14, 56, 5, 1, 1, 16, 56, 21, 20, 9, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56};
    private static final Keyword[] wordlist = new Keyword[]{new Keyword(), new Keyword(), new Keyword(), new Keyword(), new Keyword(), new Keyword(), new Keyword("end", 264, 264, LexState.EXPR_END), new Keyword("else", 269, 269, LexState.EXPR_BEG), new Keyword("case", 270, 270, LexState.EXPR_BEG), new Keyword("ensure", 263, 263, LexState.EXPR_BEG), new Keyword("module", 258, 258, LexState.EXPR_BEG), new Keyword("elsif", 268, 268, LexState.EXPR_BEG), new Keyword("def", 259, 259, LexState.EXPR_FNAME), new Keyword("rescue", 262, 297, LexState.EXPR_MID), new Keyword("not", 292, 292, LexState.EXPR_BEG), new Keyword("then", 267, 267, LexState.EXPR_BEG), new Keyword("yield", 284, 284, LexState.EXPR_ARG), new Keyword("for", 274, 274, LexState.EXPR_BEG), new Keyword("self", 286, 286, LexState.EXPR_END), new Keyword("false", 289, 289, LexState.EXPR_END), new Keyword("retry", 278, 278, LexState.EXPR_END), new Keyword("return", 283, 283, LexState.EXPR_MID), new Keyword("true", 288, 288, LexState.EXPR_END), new Keyword("if", 265, 293, LexState.EXPR_BEG), new Keyword("defined?", 299, 299, LexState.EXPR_ARG), new Keyword("super", 285, 285, LexState.EXPR_ARG), new Keyword("undef", 260, 260, LexState.EXPR_FNAME), new Keyword("break", 275, 275, LexState.EXPR_MID), new Keyword("in", 279, 279, LexState.EXPR_BEG), new Keyword("do", 280, 280, LexState.EXPR_BEG), new Keyword("nil", 287, 287, LexState.EXPR_END), new Keyword("until", 273, 296, LexState.EXPR_BEG), new Keyword("unless", 266, 294, LexState.EXPR_BEG), new Keyword("or", 291, 291, LexState.EXPR_BEG), new Keyword("next", 276, 276, LexState.EXPR_MID), new Keyword("when", 271, 271, LexState.EXPR_BEG), new Keyword("redo", 277, 277, LexState.EXPR_END), new Keyword("and", 290, 290, LexState.EXPR_BEG), new Keyword("begin", 261, 261, LexState.EXPR_BEG), new Keyword("__LINE__", 302, 302, LexState.EXPR_END), new Keyword("class", 257, 257, LexState.EXPR_CLASS), new Keyword("__FILE__", 303, 303, LexState.EXPR_END), new Keyword("END", 301, 301, LexState.EXPR_END), new Keyword("BEGIN", 300, 300, LexState.EXPR_END), new Keyword("while", 272, 295, LexState.EXPR_BEG), new Keyword(), new Keyword(), new Keyword(), new Keyword(), new Keyword(), new Keyword(), new Keyword(), new Keyword(), new Keyword(), new Keyword(), new Keyword("alias", 298, 298, LexState.EXPR_FNAME)};

    private Keyword() {
        this("", 0, 0, LexState.EXPR_BEG);
    }

    private Keyword(String name, int id0, int id1, LexState state) {
        this.name = name;
        this.id0 = id0;
        this.id1 = id1;
        this.state = state;
    }

    private static int hash(String str, int len) {
        int hval = len;
        switch (hval) {
            default: {
                hval += asso_values[str.charAt(2) & 0xFF];
            }
            case 1: 
            case 2: 
        }
        return (hval += asso_values[str.charAt(0) & 0xFF]) + asso_values[str.charAt(len - 1) & 0xFF];
    }

    public static Keyword getKeyword(String str, int len) {
        int key;
        if (len <= 8 && len >= 2 && (key = Keyword.hash(str, len)) <= 55 && key >= 6 && str.equals(Keyword.wordlist[key].name)) {
            return wordlist[key];
        }
        return null;
    }
}

