/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers.ui.quickfix;

import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.param.RootProblemPreference;
import org.eclipse.cdt.codan.internal.checkers.ui.CheckersUiActivator;
import org.eclipse.cdt.codan.internal.checkers.ui.quickfix.AbstractCaseBreakQuickFix;
import org.eclipse.cdt.codan.internal.checkers.ui.quickfix.QuickFixMessages;
import org.eclipse.cdt.core.dom.ast.IASTAttribute;
import org.eclipse.cdt.core.dom.ast.IASTAttributeList;
import org.eclipse.cdt.core.dom.ast.IASTAttributeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAttributeList;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNodeFactory;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.StandardAttributes;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;

public class CaseBreakQuickFixFallthroughAttribute
extends AbstractCaseBreakQuickFix {
    public boolean isApplicable(IMarker marker) {
        IProblem problem = this.getProblem(marker);
        if (problem == null) {
            return false;
        }
        RootProblemPreference map = (RootProblemPreference)problem.getPreference();
        boolean enabled = (Boolean)map.getChildValue("enable_fallthrough_quickfix_param");
        boolean last_case_enabled = (Boolean)map.getChildValue("last_case_param");
        ITranslationUnit tu = this.getTranslationUnitViaWorkspace(marker);
        return enabled && tu != null && tu.isCXXLanguage() && (!last_case_enabled || this.validPositionForFallthrough(tu, marker));
    }

    public String getLabel() {
        return QuickFixMessages.CaseBreakQuickFixFallthroughAttribute_Label;
    }

    public void modifyAST(IIndex index, IMarker marker) {
        try {
            IASTTranslationUnit ast = this.getTranslationUnitViaEditor(marker).getAST(index, 2);
            ICPPNodeFactory factory = (ICPPNodeFactory)ast.getASTNodeFactory();
            IASTNullStatement nullStatement = factory.newNullStatement();
            nullStatement.addAttributeSpecifier((IASTAttributeSpecifier)this.getFallthroughAttributeList(factory));
            this.addNewNodeAtMarkedCaseEnd((IASTNode)nullStatement, ast, marker);
        }
        catch (CoreException e) {
            CheckersUiActivator.log(e);
        }
    }

    private boolean validPositionForFallthrough(ITranslationUnit tu, IMarker marker) {
        try {
            IASTTranslationUnit ast = CModelUtil.toWorkingCopy((ITranslationUnit)tu).getAST(null, 2);
            IASTStatement beforeCaseEnd = this.getStmtBeforeCaseEnd(marker, ast);
            if (this.getNextStatement(beforeCaseEnd) == null) {
                return false;
            }
        }
        catch (CoreException | BadLocationException e) {
            e.printStackTrace();
        }
        return true;
    }

    private IASTAttributeList getFallthroughAttributeList(ICPPNodeFactory factory) {
        IASTAttribute attribute = factory.newAttribute(StandardAttributes.cFALLTHROUGH, null);
        ICPPASTAttributeList attributeList = factory.newAttributeList();
        attributeList.addAttribute(attribute);
        return attributeList;
    }
}

