/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.actf.model.dom.html.DocumentTypeUtil;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLDocument;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLAttribute;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLCDATASection;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLComment;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDOMImpl;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocType;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocTypeDef;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocumentFragment;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLElement;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLNode;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLPI;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLParentNode;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLText;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class SGMLDocument
extends SGMLParentNode
implements ISGMLDocument {
    private static final long serialVersionUID = -9052104600001817404L;
    public Element documentElement = null;
    public DocumentType doctype = null;
    private transient DOMImplementation domImpl;
    private transient SGMLDocTypeDef dtd;
    private Hashtable<Character, String> charNumEntities = new Hashtable();

    public SGMLDocument() {
        this(SGMLDOMImpl.getDOMImplementation());
    }

    protected SGMLDocument(DOMImplementation dOMImplementation) {
        super(null);
        this.domImpl = dOMImplementation;
    }

    void check(Node node) throws DOMException {
        if (node.getOwnerDocument() != this && !(node instanceof SGMLDocType)) {
            throw new DOMException(4, node + " created from " + node.getOwnerDocument() + " this."){
                private static final long serialVersionUID = -6949628537817157229L;
            };
        }
        switch (node.getNodeType()) {
            case 1: {
                if (this.documentElement == null) {
                    this.documentElement = (Element)node;
                    break;
                }
                throw new DOMException(3, " document cannot have roots."){
                    private static final long serialVersionUID = -8867384684522317782L;
                };
            }
            case 7: 
            case 8: {
                break;
            }
            case 10: {
                this.doctype = (DocumentType)node;
                ((SGMLNode)node).ownerDocument = this;
                break;
            }
            default: {
                throw new DOMException(3, node + " is not allowed as a child of " + this){
                    private static final long serialVersionUID = 7083250644035192730L;
                };
            }
        }
    }

    public Node cloneNode(boolean bl) {
        SGMLDocument sGMLDocument = (SGMLDocument)super.cloneNode(true);
        this.setOwnerDocument(sGMLDocument, sGMLDocument);
        Node node = sGMLDocument.firstChild;
        while (node != null) {
            if (node instanceof Element) {
                sGMLDocument.documentElement = (Element)node;
            } else if (node instanceof DocumentType) {
                sGMLDocument.doctype = (DocumentType)node;
            }
            node = node.getNextSibling();
        }
        this.processNodeDeepForOptimization(sGMLDocument.documentElement);
        return sGMLDocument;
    }

    private void processNodeDeepForOptimization(Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                this.processNodeDeepForOptimization((Element)node);
            }
            node = node.getNextSibling();
        }
        if (element instanceof SGMLElement) {
            ((SGMLElement)element).processNodeForOptimization(element);
        }
    }

    private void setOwnerDocument(SGMLNode sGMLNode, Document document) {
        sGMLNode.ownerDocument = document;
        SGMLNode sGMLNode2 = (SGMLNode)sGMLNode.getFirstChild();
        while (sGMLNode2 != null) {
            this.setOwnerDocument(sGMLNode2, document);
            sGMLNode2 = (SGMLNode)sGMLNode2.getNextSibling();
        }
    }

    public Attr createAttribute(String string) {
        return new SGMLAttribute(string, string, this);
    }

    public CDATASection createCDATASection(String string) {
        return new SGMLCDATASection(string, this);
    }

    public Comment createComment(String string) {
        return new SGMLComment(string, this);
    }

    public DocumentFragment createDocumentFragment() {
        return new SGMLDocumentFragment(this);
    }

    public Element createElement(String string) {
        return new SGMLElement(string, this);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        throw new DOMException(9, "cannot create Entity Ref."){
            private static final long serialVersionUID = -4581301359508117945L;
        };
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) {
        return new SGMLPI(string, string2, this);
    }

    public Text createTextNode(String string) {
        return new SGMLText(string, this);
    }

    public DocumentType getDoctype() {
        return this.doctype;
    }

    public Element getDocumentElement() {
        return this.documentElement;
    }

    public Node getDocumentType() {
        return this.doctype;
    }

    public NodeList getElementsByTagName(String string) {
        return this.documentElement.getElementsByTagName(string);
    }

    public DOMImplementation getImplementation() {
        return this.domImpl;
    }

    public Node getNextSibling() {
        return null;
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public String getNodeValue() {
        return null;
    }

    public Document getOwnerDocument() {
        return null;
    }

    public Node getParentNode() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public Node removeChild(Node node) throws DOMException {
        if (node == this.documentElement) {
            this.documentElement = null;
        } else if (node == this.doctype) {
            this.doctype = null;
        }
        return super.removeChild(node);
    }

    public void setNodeValue(String string) throws DOMException {
        throw new DOMException(7, "#document is always null"){
            private static final long serialVersionUID = 6689389325290139309L;
        };
    }

    public void printAsXML(String string, URL uRL, PrintWriter printWriter, boolean bl) throws IOException {
        this.printAsXML(string, uRL, printWriter, bl, null);
    }

    public void printAsXML(String string, URL uRL, PrintWriter printWriter, boolean bl, String string2) throws IOException {
        if (string2 == null) {
            printWriter.println("<?xml version=\"1.0\"?>");
        } else {
            printWriter.println("<?xml version=\"1.0\" encoding=\"" + string2 + "\"?>");
        }
        if (string != null) {
            printWriter.print("<!DOCTYPE " + this.documentElement.getTagName() + " PUBLIC \"" + string + '\"');
            if (uRL != null) {
                printWriter.println(" \"" + uRL + "\">");
            } else {
                printWriter.println('>');
            }
        }
        ((SGMLElement)this.documentElement).printAsXML(printWriter, 0, bl);
        printWriter.println();
        printWriter.flush();
    }

    public void printAsXML(PrintWriter printWriter, boolean bl, String string) throws IOException {
        this.printAsXML(null, null, printWriter, bl, string);
    }

    public void printAsSGML(PrintWriter printWriter, boolean bl) throws IOException {
        if (this.doctype != null) {
            String string = DocumentTypeUtil.getOriginalID(this.doctype);
            if (string.isEmpty()) {
                printWriter.println("<!DOCTYPE html>");
            } else if (string.equalsIgnoreCase("about:legacy-compat")) {
                printWriter.println("<!DOCTYPE html SYSTEM \"about:legacy-compat\">");
            } else {
                printWriter.println(this.doctype.toString());
            }
        }
        if (this.documentElement != null) {
            ((SGMLElement)this.documentElement).printAsSGML(printWriter, 0, bl);
        }
        printWriter.println();
        printWriter.flush();
    }

    public SGMLDocTypeDef getDTD() {
        return this.dtd;
    }

    public void setDTD(SGMLDocTypeDef sGMLDocTypeDef) {
        this.dtd = sGMLDocTypeDef;
    }

    String getEntityOrigin(Character c) {
        return this.charNumEntities.get(c);
    }

    void putCharNumEntity(Character c, String string) {
        this.charNumEntities.put(c, string);
    }

    String getCharNumEntity(Character c) {
        return this.charNumEntities.get(c);
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        Object object;
        Node node2;
        switch (node.getNodeType()) {
            case 1: {
                node2 = this.createElement(node.getNodeName());
                object = node.getAttributes();
                int n = 0;
                while (n < object.getLength()) {
                    Attr attr = (Attr)object.item(n);
                    if (attr.getSpecified()) {
                        Attr attr2 = this.createAttribute(attr.getNodeName());
                        attr2.setValue(attr.getValue());
                        ((Element)node2).setAttributeNode(attr2);
                    }
                    ++n;
                }
                break;
            }
            case 2: {
                node2 = this.createAttribute(node.getNodeName());
                ((Attr)node2).setValue(node.getNodeValue());
                break;
            }
            case 3: {
                node2 = this.createTextNode(node.getNodeValue());
                break;
            }
            case 4: {
                node2 = this.createCDATASection(node.getNodeValue());
                break;
            }
            case 8: {
                node2 = this.createComment(node.getNodeValue());
                break;
            }
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                node2 = this.createProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
                break;
            }
            case 5: {
                throw new DOMException(9, "ENTITY_REFERENCE: " + node){
                    private static final long serialVersionUID = 1578579363722608207L;
                };
            }
            case 6: {
                throw new DOMException(9, "ENTITY: " + node){
                    private static final long serialVersionUID = -450181572985174561L;
                };
            }
            case 9: {
                throw new DOMException(9, "DOCUMENT: " + node){
                    private static final long serialVersionUID = 8785157203267073381L;
                };
            }
            case 10: {
                throw new DOMException(9, "DOCUMENT_TYPE: " + node){
                    private static final long serialVersionUID = 5629745929750604049L;
                };
            }
            case 11: {
                node2 = this.createDocumentFragment();
                break;
            }
            case 12: {
                throw new DOMException(9, "NOTATION: " + node){
                    private static final long serialVersionUID = 1787799543281735366L;
                };
            }
            default: {
                throw new DOMException(9, "Unknown node type: " + node.getNodeType()){
                    private static final long serialVersionUID = -9119985548894040858L;
                };
            }
        }
        if (bl) {
            object = node.getFirstChild();
            while (object != null) {
                node2.appendChild(this.importNode((Node)object, true));
                object = object.getNextSibling();
            }
        }
        return node2;
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        return this.createElement(string2);
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        return this.createAttribute(string2);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        return this.getElementsByTagName(string2);
    }

    public Element getElementById(String string) {
        if (this.documentElement instanceof SGMLElement) {
            HashMap<String, List<WeakReference<Element>>> hashMap = SGMLParentNode.getIdMap(this);
            List<WeakReference<Element>> list = hashMap.get(string);
            if (list == null) {
                return null;
            }
            return (Element)list.get(0).get();
        }
        return null;
    }

    public Node adoptNode(Node node) throws DOMException {
        return null;
    }

    public String getDocumentURI() {
        return null;
    }

    public DOMConfiguration getDomConfig() {
        return null;
    }

    public String getInputEncoding() {
        return null;
    }

    public boolean getStrictErrorChecking() {
        return false;
    }

    public String getXmlEncoding() {
        return null;
    }

    public boolean getXmlStandalone() {
        return false;
    }

    public String getXmlVersion() {
        return null;
    }

    public void normalizeDocument() {
    }

    public Node renameNode(Node node, String string, String string2) throws DOMException {
        return null;
    }

    public void setDocumentURI(String string) {
    }

    public void setStrictErrorChecking(boolean bl) {
    }

    public void setXmlStandalone(boolean bl) throws DOMException {
    }

    public void setXmlVersion(String string) throws DOMException {
    }
}

