/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.edit.command;

import net.sourceforge.nattable.command.AbstractLayerCommandHandler;
import net.sourceforge.nattable.edit.command.UpdateDataCommand;
import net.sourceforge.nattable.layer.DataLayer;
import net.sourceforge.nattable.layer.event.CellVisualChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateDataCommandHandler
extends AbstractLayerCommandHandler<UpdateDataCommand> {
    private final DataLayer dataLayer;

    public UpdateDataCommandHandler(DataLayer dataLayer) {
        this.dataLayer = dataLayer;
    }

    @Override
    public Class<UpdateDataCommand> getCommandClass() {
        return UpdateDataCommand.class;
    }

    @Override
    protected boolean doCommand(UpdateDataCommand command) {
        try {
            int columnPosition = command.getColumnPosition();
            int rowPosition = command.getRowPosition();
            this.dataLayer.getDataProvider().setDataValue(columnPosition, rowPosition, command.getNewValue());
            this.dataLayer.fireLayerEvent(new CellVisualChangeEvent(this.dataLayer, columnPosition, rowPosition));
            return true;
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace(System.err);
            System.err.println("Failed to update value to: " + command.getNewValue());
            return false;
        }
    }
}

