/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.command;

import net.sourceforge.nattable.command.ILayerCommand;
import net.sourceforge.nattable.command.LayerCommandUtil;
import net.sourceforge.nattable.coordinate.PositionCoordinate;
import net.sourceforge.nattable.layer.ILayer;

public abstract class AbstractPositionCommand
implements ILayerCommand {
    private PositionCoordinate positionCoordinate;

    protected AbstractPositionCommand(ILayer layer, int columnPosition, int rowPosition) {
        this.positionCoordinate = new PositionCoordinate(layer, columnPosition, rowPosition);
    }

    protected AbstractPositionCommand(AbstractPositionCommand command) {
        this.positionCoordinate = command.positionCoordinate;
    }

    public boolean convertToTargetLayer(ILayer targetLayer) {
        this.positionCoordinate = LayerCommandUtil.convertPositionToTargetContext(this.positionCoordinate, targetLayer);
        return this.positionCoordinate != null;
    }

    public int getColumnPosition() {
        return this.positionCoordinate.getColumnPosition();
    }

    public int getRowPosition() {
        return this.positionCoordinate.getRowPosition();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " columnPosition=" + this.positionCoordinate.getColumnPosition() + ", rowPosition=" + this.positionCoordinate.getRowPosition();
    }
}

