/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.partition.set.PartitionMutableSet;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.api.set.SetIterable;
import org.eclipse.collections.api.set.UnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.procedure.CollectionAddProcedure;
import org.eclipse.collections.impl.block.procedure.PartitionPredicate2Procedure;
import org.eclipse.collections.impl.block.procedure.PartitionProcedure;
import org.eclipse.collections.impl.block.procedure.SelectInstancesOfProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectBooleanProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectByteProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectCharProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectDoubleProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectFloatProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectIntProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectLongProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectShortProcedure;
import org.eclipse.collections.impl.collection.mutable.AbstractCollectionAdapter;
import org.eclipse.collections.impl.lazy.parallel.set.NonParallelUnsortedSetIterable;
import org.eclipse.collections.impl.multimap.set.UnifiedSetMultimap;
import org.eclipse.collections.impl.partition.set.PartitionUnifiedSet;
import org.eclipse.collections.impl.set.mutable.SynchronizedMutableSet;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.UnmodifiableMutableSet;
import org.eclipse.collections.impl.set.mutable.primitive.BooleanHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.utility.ArrayIterate;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.internal.SetIterables;
import org.eclipse.collections.impl.utility.internal.SetIterate;

public final class SetAdapter<T>
extends AbstractCollectionAdapter<T>
implements Serializable,
MutableSet<T> {
    private static final long serialVersionUID = 1L;
    private final Set<T> delegate;

    SetAdapter(Set<T> newDelegate) {
        if (newDelegate == null) {
            throw new NullPointerException("SetAdapter may not wrap null");
        }
        this.delegate = newDelegate;
    }

    @Override
    protected Set<T> getDelegate() {
        return this.delegate;
    }

    public MutableSet<T> asUnmodifiable() {
        return UnmodifiableMutableSet.of(this);
    }

    public MutableSet<T> asSynchronized() {
        return SynchronizedMutableSet.of(this);
    }

    public ImmutableSet<T> toImmutable() {
        return Sets.immutable.withAll(this.delegate);
    }

    public static <E> MutableSet<E> adapt(Set<E> set) {
        if (set instanceof MutableSet) {
            return (MutableSet)set;
        }
        return new SetAdapter<E>(set);
    }

    public MutableSet<T> clone() {
        return UnifiedSet.newSet(this.delegate);
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.delegate.containsAll(collection);
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public SetAdapter<T> with(T element) {
        this.add(element);
        return this;
    }

    public SetAdapter<T> with(T element1, T element2) {
        this.add(element1);
        this.add(element2);
        return this;
    }

    public SetAdapter<T> with(T element1, T element2, T element3) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this;
    }

    public SetAdapter<T> with(T ... elements) {
        ArrayIterate.forEach(elements, CollectionAddProcedure.on(this.delegate));
        return this;
    }

    public SetAdapter<T> without(T element) {
        this.remove(element);
        return this;
    }

    public SetAdapter<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    public SetAdapter<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    @Deprecated
    public MutableSet<T> newEmpty() {
        return UnifiedSet.newSet();
    }

    @Override
    public MutableSet<T> tap(Procedure<? super T> procedure) {
        Iterate.forEach(this.delegate, procedure);
        return this;
    }

    @Override
    public MutableSet<T> select(Predicate<? super T> predicate) {
        return Iterate.select(this.delegate, predicate, UnifiedSet.newSet());
    }

    @Override
    public MutableSet<T> reject(Predicate<? super T> predicate) {
        return Iterate.reject(this.delegate, predicate, UnifiedSet.newSet());
    }

    @Override
    public PartitionMutableSet<T> partition(Predicate<? super T> predicate) {
        PartitionUnifiedSet partitionUnifiedSet = new PartitionUnifiedSet();
        this.forEach(new PartitionProcedure<T>(predicate, partitionUnifiedSet));
        return partitionUnifiedSet;
    }

    @Override
    public <P> PartitionMutableSet<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        PartitionUnifiedSet partitionUnifiedSet = new PartitionUnifiedSet();
        this.forEach(new PartitionPredicate2Procedure<T, P>(predicate, parameter, partitionUnifiedSet));
        return partitionUnifiedSet;
    }

    @Override
    public <S> MutableSet<S> selectInstancesOf(Class<S> clazz) {
        UnifiedSet result = UnifiedSet.newSet();
        this.forEach(new SelectInstancesOfProcedure<S>(clazz, result));
        return result;
    }

    @Override
    public <V> MutableSet<V> collect(Function<? super T, ? extends V> function) {
        return Iterate.collect(this.delegate, function, UnifiedSet.newSet());
    }

    public MutableBooleanSet collectBoolean(BooleanFunction<? super T> booleanFunction) {
        BooleanHashSet result = new BooleanHashSet();
        this.forEach(new CollectBooleanProcedure<T>(booleanFunction, (MutableBooleanCollection)result));
        return result;
    }

    public MutableByteSet collectByte(ByteFunction<? super T> byteFunction) {
        ByteHashSet result = new ByteHashSet(this.size());
        this.forEach(new CollectByteProcedure<T>(byteFunction, (MutableByteCollection)result));
        return result;
    }

    public MutableCharSet collectChar(CharFunction<? super T> charFunction) {
        CharHashSet result = new CharHashSet(this.size());
        this.forEach(new CollectCharProcedure<T>(charFunction, (MutableCharCollection)result));
        return result;
    }

    public MutableDoubleSet collectDouble(DoubleFunction<? super T> doubleFunction) {
        DoubleHashSet result = new DoubleHashSet(this.size());
        this.forEach(new CollectDoubleProcedure<T>(doubleFunction, (MutableDoubleCollection)result));
        return result;
    }

    public MutableFloatSet collectFloat(FloatFunction<? super T> floatFunction) {
        FloatHashSet result = new FloatHashSet(this.size());
        this.forEach(new CollectFloatProcedure<T>(floatFunction, (MutableFloatCollection)result));
        return result;
    }

    public MutableIntSet collectInt(IntFunction<? super T> intFunction) {
        IntHashSet result = new IntHashSet(this.size());
        this.forEach(new CollectIntProcedure<T>(intFunction, (MutableIntCollection)result));
        return result;
    }

    public MutableLongSet collectLong(LongFunction<? super T> longFunction) {
        LongHashSet result = new LongHashSet(this.size());
        this.forEach(new CollectLongProcedure<T>(longFunction, (MutableLongCollection)result));
        return result;
    }

    public MutableShortSet collectShort(ShortFunction<? super T> shortFunction) {
        ShortHashSet result = new ShortHashSet(this.size());
        this.forEach(new CollectShortProcedure<T>(shortFunction, (MutableShortCollection)result));
        return result;
    }

    @Override
    public <V> MutableSet<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return Iterate.flatCollect(this.delegate, function, UnifiedSet.newSet());
    }

    @Override
    public <V> MutableSet<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return Iterate.collectIf(this.delegate, predicate, function, UnifiedSet.newSet());
    }

    @Override
    public <V> UnifiedSetMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return Iterate.groupBy(this.delegate, function, UnifiedSetMultimap.newMultimap());
    }

    @Override
    public <V> UnifiedSetMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return Iterate.groupByEach(this.delegate, function, UnifiedSetMultimap.newMultimap());
    }

    @Override
    public <P> MutableSet<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return Iterate.selectWith(this.delegate, predicate, parameter, UnifiedSet.newSet());
    }

    @Override
    public <P> MutableSet<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return Iterate.rejectWith(this.delegate, predicate, parameter, UnifiedSet.newSet());
    }

    @Override
    public <P, V> MutableSet<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return Iterate.collectWith(this.delegate, function, parameter, UnifiedSet.newSet());
    }

    @Override
    @Deprecated
    public <S> MutableSet<Pair<T, S>> zip(Iterable<S> that) {
        if (that instanceof Collection || that instanceof RichIterable) {
            int thatSize = Iterate.sizeOf(that);
            UnifiedSet target = UnifiedSet.newSet(Math.min(this.size(), thatSize));
            return Iterate.zip(this, that, target);
        }
        return Iterate.zip(this, that, UnifiedSet.newSet());
    }

    @Override
    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        return Iterate.zipWithIndex(this, UnifiedSet.newSet(this.size()));
    }

    @Override
    public boolean removeAllIterable(Iterable<?> iterable) {
        return SetIterate.removeAllIterable(this, iterable);
    }

    public MutableSet<T> union(SetIterable<? extends T> set) {
        return SetIterables.union(this, set);
    }

    public <R extends Set<T>> R unionInto(SetIterable<? extends T> set, R targetSet) {
        return SetIterables.unionInto(this, set, targetSet);
    }

    public MutableSet<T> intersect(SetIterable<? extends T> set) {
        return SetIterables.intersect(this, set);
    }

    public <R extends Set<T>> R intersectInto(SetIterable<? extends T> set, R targetSet) {
        return SetIterables.intersectInto(this, set, targetSet);
    }

    public MutableSet<T> difference(SetIterable<? extends T> subtrahendSet) {
        return SetIterables.difference(this, subtrahendSet);
    }

    public <R extends Set<T>> R differenceInto(SetIterable<? extends T> subtrahendSet, R targetSet) {
        return SetIterables.differenceInto(this, subtrahendSet, targetSet);
    }

    public MutableSet<T> symmetricDifference(SetIterable<? extends T> setB) {
        return SetIterables.symmetricDifference(this, setB);
    }

    public <R extends Set<T>> R symmetricDifferenceInto(SetIterable<? extends T> set, R targetSet) {
        return SetIterables.symmetricDifferenceInto(this, set, targetSet);
    }

    public boolean isSubsetOf(SetIterable<? extends T> candidateSuperset) {
        return SetIterables.isSubsetOf(this, candidateSuperset);
    }

    public boolean isProperSubsetOf(SetIterable<? extends T> candidateSuperset) {
        return SetIterables.isProperSubsetOf(this, candidateSuperset);
    }

    public MutableSet<UnsortedSetIterable<T>> powerSet() {
        return SetIterables.powerSet(this);
    }

    public <B> LazyIterable<Pair<T, B>> cartesianProduct(SetIterable<B> set) {
        return SetIterables.cartesianProduct(this, set);
    }

    public ParallelUnsortedSetIterable<T> asParallel(ExecutorService executorService, int batchSize) {
        return new NonParallelUnsortedSetIterable(this);
    }
}

