/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.api;

import jakarta.json.JsonObject;
import java.net.URI;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.JsonLdOptions;
import no.hasmac.jsonld.JsonLdVersion;
import no.hasmac.jsonld.api.CommonApi;
import no.hasmac.jsonld.api.LoaderApi;
import no.hasmac.jsonld.document.Document;
import no.hasmac.jsonld.loader.DocumentLoader;
import no.hasmac.jsonld.processor.CompactionProcessor;

public final class CompactionApi
implements CommonApi<CompactionApi>,
LoaderApi<CompactionApi> {
    private final Document document;
    private final URI documentUri;
    private final Document context;
    private final URI contextUri;
    private JsonLdOptions options;

    public CompactionApi(URI documentUri, Document context) {
        this.document = null;
        this.documentUri = documentUri;
        this.context = context;
        this.contextUri = null;
        this.options = new JsonLdOptions();
    }

    public CompactionApi(URI documentUri, URI contextUri) {
        this.document = null;
        this.documentUri = documentUri;
        this.context = null;
        this.contextUri = contextUri;
        this.options = new JsonLdOptions();
    }

    public CompactionApi(Document document, Document context) {
        this.document = document;
        this.documentUri = null;
        this.context = context;
        this.contextUri = null;
        this.options = new JsonLdOptions();
    }

    public CompactionApi(Document document, URI contextUri) {
        this.document = document;
        this.documentUri = null;
        this.context = null;
        this.contextUri = contextUri;
        this.options = new JsonLdOptions();
    }

    @Override
    public CompactionApi options(JsonLdOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Parameter 'options' is null.");
        }
        this.options = options;
        return this;
    }

    @Override
    public CompactionApi mode(JsonLdVersion processingMode) {
        this.options.setProcessingMode(processingMode);
        return this;
    }

    @Override
    public CompactionApi base(URI baseUri) {
        this.options.setBase(baseUri);
        return this;
    }

    public CompactionApi compactArrays(boolean enable) {
        this.options.setCompactArrays(enable);
        return this;
    }

    public CompactionApi compactArrays() {
        return this.compactArrays(true);
    }

    public CompactionApi compactToRelative(boolean enable) {
        this.options.setCompactToRelative(enable);
        return this;
    }

    public CompactionApi compactToRelative() {
        return this.compactToRelative(true);
    }

    @Override
    public CompactionApi loader(DocumentLoader loader) {
        this.options.setDocumentLoader(loader);
        return this;
    }

    @Override
    public CompactionApi ordered(boolean enable) {
        this.options.setOrdered(enable);
        return this;
    }

    public CompactionApi rdfStar() {
        this.options.setRdfStar(true);
        return this;
    }

    public JsonObject get() throws JsonLdError {
        if (this.document != null) {
            if (this.context != null) {
                return CompactionProcessor.compact(this.document, this.context, this.options);
            }
            if (this.contextUri != null) {
                return CompactionProcessor.compact(this.document, this.contextUri, this.options);
            }
        }
        if (this.documentUri != null) {
            if (this.context != null) {
                return CompactionProcessor.compact(this.documentUri, this.context, this.options);
            }
            if (this.contextUri != null) {
                return CompactionProcessor.compact(this.documentUri, this.contextUri, this.options);
            }
        }
        throw new IllegalStateException();
    }
}

