/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.graphpattern;

import java.util.function.Consumer;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sparqlbuilder.constraint.propertypath.builder.EmptyPropertyPathBuilder;
import org.eclipse.rdf4j.sparqlbuilder.core.Projectable;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.AlternativeGraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.BNodeTriplePattern;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.FilterExistsGraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPatternNotTriples;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GroupGraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.MinusGraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.SubSelect;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.TriplePattern;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.TriplesSameSubject;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfBlankNode;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfObject;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfPredicate;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfPredicateObjectList;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfSubject;

public class GraphPatterns {
    private GraphPatterns() {
    }

    public static TriplePattern tp(RdfSubject subject, RdfPredicate predicate, RdfObject ... objects) {
        return new TriplesSameSubject(subject, predicate, objects);
    }

    public static TriplePattern tp(RdfSubject subject, RdfPredicate predicate, Value ... objects) {
        return GraphPatterns.tp(subject, predicate, Rdf.objects(objects));
    }

    public static TriplePattern tp(RdfSubject subject, IRI predicate, RdfObject ... objects) {
        return GraphPatterns.tp(subject, (RdfPredicate)Rdf.iri(predicate), objects);
    }

    public static TriplePattern tp(RdfSubject subject, IRI predicate, Value ... objects) {
        return GraphPatterns.tp(subject, (RdfPredicate)Rdf.iri(predicate), Rdf.objects(objects));
    }

    public static TriplePattern tp(Resource subject, RdfPredicate predicate, RdfObject ... objects) {
        if (subject instanceof IRI) {
            return GraphPatterns.tp((RdfSubject)Rdf.iri((IRI)subject), predicate, objects);
        }
        return GraphPatterns.tp((RdfSubject)Rdf.bNode(((BNode)subject).getID()), predicate, objects);
    }

    public static TriplePattern tp(Resource subject, RdfPredicate predicate, Value ... objects) {
        return GraphPatterns.tp(subject, predicate, Rdf.objects(objects));
    }

    public static TriplePattern tp(Resource subject, IRI predicate, RdfObject ... objects) {
        return GraphPatterns.tp(subject, (RdfPredicate)Rdf.iri(predicate), objects);
    }

    public static TriplePattern tp(Resource subject, IRI predicate, Value ... objects) {
        return GraphPatterns.tp(subject, (RdfPredicate)Rdf.iri(predicate), Rdf.objects(objects));
    }

    public static TriplePattern tp(RdfSubject subject, RdfPredicateObjectList ... lists) {
        return new TriplesSameSubject(subject, lists);
    }

    public static TriplePattern tp(RdfBlankNode.PropertiesBlankNode bnode) {
        return new BNodeTriplePattern(bnode);
    }

    public static TriplePattern tp(RdfSubject subject, Consumer<EmptyPropertyPathBuilder> propertyPathConfigurer, RdfObject ... objects) {
        EmptyPropertyPathBuilder builder = new EmptyPropertyPathBuilder();
        propertyPathConfigurer.accept(builder);
        return new TriplesSameSubject(subject, builder.build(), objects);
    }

    public static GraphPatternNotTriples and(GraphPattern ... patterns) {
        GroupGraphPattern and = new GroupGraphPattern();
        return new GraphPatternNotTriples(and.and(patterns));
    }

    public static GraphPatternNotTriples union(GraphPattern ... patterns) {
        AlternativeGraphPattern union = new AlternativeGraphPattern();
        return new GraphPatternNotTriples(union.union(patterns));
    }

    public static GraphPatternNotTriples optional(GraphPattern ... patterns) {
        return GraphPatterns.and(patterns).optional();
    }

    public static GraphPatternNotTriples filterExists(GraphPattern ... patterns) {
        return GraphPatterns.filterExists(true, patterns);
    }

    public static GraphPatternNotTriples filterNotExists(GraphPattern ... patterns) {
        return GraphPatterns.filterExists(false, patterns);
    }

    public static GraphPatternNotTriples minus(GraphPattern ... patterns) {
        MinusGraphPattern minus = new MinusGraphPattern();
        minus.and(patterns);
        return new GraphPatternNotTriples(minus);
    }

    public static GraphPatternNotTriples filterExists(boolean exists, GraphPattern ... patterns) {
        FilterExistsGraphPattern filterExists = new FilterExistsGraphPattern().exists(exists);
        filterExists.and(patterns);
        return new GraphPatternNotTriples(filterExists);
    }

    public static SubSelect select(Projectable ... projectables) {
        return new SubSelect().select(projectables);
    }

    static GroupGraphPattern extractOrConvertToGGP(GraphPattern pattern) {
        if (pattern instanceof GroupGraphPattern) {
            return (GroupGraphPattern)pattern;
        }
        if (pattern instanceof GraphPatternNotTriples) {
            GraphPatternNotTriples gp = (GraphPatternNotTriples)pattern;
            if (gp.gp instanceof GroupGraphPattern) {
                return (GroupGraphPattern)gp.gp;
            }
        }
        return new GroupGraphPattern(pattern);
    }
}

