/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb.util;

import java.nio.ByteBuffer;
import org.eclipse.rdf4j.sail.lmdb.Varint;

public final class IndexKeyWriters {
    private static final int CACHE_SIZE = 4096;
    private static final int MASK = 4095;

    private IndexKeyWriters() {
    }

    public static KeyWriter forFieldSeq(String fieldSeq) {
        BasicWriter basic;
        switch (fieldSeq) {
            case "spoc": {
                basic = IndexKeyWriters::spoc;
                break;
            }
            case "spco": {
                basic = IndexKeyWriters::spco;
                break;
            }
            case "sopc": {
                basic = IndexKeyWriters::sopc;
                break;
            }
            case "socp": {
                basic = IndexKeyWriters::socp;
                break;
            }
            case "scpo": {
                basic = IndexKeyWriters::scpo;
                break;
            }
            case "scop": {
                basic = IndexKeyWriters::scop;
                break;
            }
            case "psoc": {
                basic = IndexKeyWriters::psoc;
                break;
            }
            case "psco": {
                basic = IndexKeyWriters::psco;
                break;
            }
            case "posc": {
                basic = IndexKeyWriters::posc;
                break;
            }
            case "pocs": {
                basic = IndexKeyWriters::pocs;
                break;
            }
            case "pcso": {
                basic = IndexKeyWriters::pcso;
                break;
            }
            case "pcos": {
                basic = IndexKeyWriters::pcos;
                break;
            }
            case "ospc": {
                basic = IndexKeyWriters::ospc;
                break;
            }
            case "oscp": {
                basic = IndexKeyWriters::oscp;
                break;
            }
            case "opsc": {
                basic = IndexKeyWriters::opsc;
                break;
            }
            case "opcs": {
                basic = IndexKeyWriters::opcs;
                break;
            }
            case "ocsp": {
                basic = IndexKeyWriters::ocsp;
                break;
            }
            case "ocps": {
                basic = IndexKeyWriters::ocps;
                break;
            }
            case "cspo": {
                basic = IndexKeyWriters::cspo;
                break;
            }
            case "csop": {
                basic = IndexKeyWriters::csop;
                break;
            }
            case "cpso": {
                basic = IndexKeyWriters::cpso;
                break;
            }
            case "cpos": {
                basic = IndexKeyWriters::cpos;
                break;
            }
            case "cosp": {
                basic = IndexKeyWriters::cosp;
                break;
            }
            case "cops": {
                basic = IndexKeyWriters::cops;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported field sequence: " + fieldSeq);
            }
        }
        return new CachingKeyWriter(basic);
    }

    public static MatcherFactory matcherFactory(String fieldSeq) {
        switch (fieldSeq) {
            case "spoc": {
                return IndexKeyWriters::spocShouldMatch;
            }
            case "spco": {
                return IndexKeyWriters::spcoShouldMatch;
            }
            case "sopc": {
                return IndexKeyWriters::sopcShouldMatch;
            }
            case "socp": {
                return IndexKeyWriters::socpShouldMatch;
            }
            case "scpo": {
                return IndexKeyWriters::scpoShouldMatch;
            }
            case "scop": {
                return IndexKeyWriters::scopShouldMatch;
            }
            case "psoc": {
                return IndexKeyWriters::psocShouldMatch;
            }
            case "psco": {
                return IndexKeyWriters::pscoShouldMatch;
            }
            case "posc": {
                return IndexKeyWriters::poscShouldMatch;
            }
            case "pocs": {
                return IndexKeyWriters::pocsShouldMatch;
            }
            case "pcso": {
                return IndexKeyWriters::pcsoShouldMatch;
            }
            case "pcos": {
                return IndexKeyWriters::pcosShouldMatch;
            }
            case "ospc": {
                return IndexKeyWriters::ospcShouldMatch;
            }
            case "oscp": {
                return IndexKeyWriters::oscpShouldMatch;
            }
            case "opsc": {
                return IndexKeyWriters::opscShouldMatch;
            }
            case "opcs": {
                return IndexKeyWriters::opcsShouldMatch;
            }
            case "ocsp": {
                return IndexKeyWriters::ocspShouldMatch;
            }
            case "ocps": {
                return IndexKeyWriters::ocpsShouldMatch;
            }
            case "cspo": {
                return IndexKeyWriters::cspoShouldMatch;
            }
            case "csop": {
                return IndexKeyWriters::csopShouldMatch;
            }
            case "cpso": {
                return IndexKeyWriters::cpsoShouldMatch;
            }
            case "cpos": {
                return IndexKeyWriters::cposShouldMatch;
            }
            case "cosp": {
                return IndexKeyWriters::cospShouldMatch;
            }
            case "cops": {
                return IndexKeyWriters::copsShouldMatch;
            }
        }
        throw new IllegalArgumentException("Unsupported field sequence: " + fieldSeq);
    }

    static void spoc(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, subj);
        Varint.writeUnsigned(bb, pred);
        Varint.writeUnsigned(bb, obj);
        Varint.writeUnsigned(bb, context);
    }

    static void spco(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, subj);
        Varint.writeUnsigned(bb, pred);
        Varint.writeUnsigned(bb, context);
        Varint.writeUnsigned(bb, obj);
    }

    static void sopc(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, subj);
        Varint.writeUnsigned(bb, obj);
        Varint.writeUnsigned(bb, pred);
        Varint.writeUnsigned(bb, context);
    }

    static void socp(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, subj);
        Varint.writeUnsigned(bb, obj);
        Varint.writeUnsigned(bb, context);
        Varint.writeUnsigned(bb, pred);
    }

    static void scpo(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, subj);
        Varint.writeUnsigned(bb, context);
        Varint.writeUnsigned(bb, pred);
        Varint.writeUnsigned(bb, obj);
    }

    static void scop(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, subj);
        Varint.writeUnsigned(bb, context);
        Varint.writeUnsigned(bb, obj);
        Varint.writeUnsigned(bb, pred);
    }

    static void psoc(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, pred);
        Varint.writeUnsigned(bb, subj);
        Varint.writeUnsigned(bb, obj);
        Varint.writeUnsigned(bb, context);
    }

    static void psco(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, pred);
        Varint.writeUnsigned(bb, subj);
        Varint.writeUnsigned(bb, context);
        Varint.writeUnsigned(bb, obj);
    }

    static void posc(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, pred);
        Varint.writeUnsigned(bb, obj);
        Varint.writeUnsigned(bb, subj);
        Varint.writeUnsigned(bb, context);
    }

    static void pocs(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, pred);
        Varint.writeUnsigned(bb, obj);
        Varint.writeUnsigned(bb, context);
        Varint.writeUnsigned(bb, subj);
    }

    static void pcso(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, pred);
        Varint.writeUnsigned(bb, context);
        Varint.writeUnsigned(bb, subj);
        Varint.writeUnsigned(bb, obj);
    }

    static void pcos(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, pred);
        Varint.writeUnsigned(bb, context);
        Varint.writeUnsigned(bb, obj);
        Varint.writeUnsigned(bb, subj);
    }

    static void ospc(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, obj);
        Varint.writeUnsigned(bb, subj);
        Varint.writeUnsigned(bb, pred);
        Varint.writeUnsigned(bb, context);
    }

    static void oscp(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, obj);
        Varint.writeUnsigned(bb, subj);
        Varint.writeUnsigned(bb, context);
        Varint.writeUnsigned(bb, pred);
    }

    static void opsc(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, obj);
        Varint.writeUnsigned(bb, pred);
        Varint.writeUnsigned(bb, subj);
        Varint.writeUnsigned(bb, context);
    }

    static void opcs(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, obj);
        Varint.writeUnsigned(bb, pred);
        Varint.writeUnsigned(bb, context);
        Varint.writeUnsigned(bb, subj);
    }

    static void ocsp(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, obj);
        Varint.writeUnsigned(bb, context);
        Varint.writeUnsigned(bb, subj);
        Varint.writeUnsigned(bb, pred);
    }

    static void ocps(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, obj);
        Varint.writeUnsigned(bb, context);
        Varint.writeUnsigned(bb, pred);
        Varint.writeUnsigned(bb, subj);
    }

    static void cspo(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, context);
        Varint.writeUnsigned(bb, subj);
        Varint.writeUnsigned(bb, pred);
        Varint.writeUnsigned(bb, obj);
    }

    static void csop(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, context);
        Varint.writeUnsigned(bb, subj);
        Varint.writeUnsigned(bb, obj);
        Varint.writeUnsigned(bb, pred);
    }

    static void cpso(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, context);
        Varint.writeUnsigned(bb, pred);
        Varint.writeUnsigned(bb, subj);
        Varint.writeUnsigned(bb, obj);
    }

    static void cpos(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, context);
        Varint.writeUnsigned(bb, pred);
        Varint.writeUnsigned(bb, obj);
        Varint.writeUnsigned(bb, subj);
    }

    static void cosp(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, context);
        Varint.writeUnsigned(bb, obj);
        Varint.writeUnsigned(bb, subj);
        Varint.writeUnsigned(bb, pred);
    }

    static void cops(ByteBuffer bb, long subj, long pred, long obj, long context) {
        Varint.writeUnsigned(bb, context);
        Varint.writeUnsigned(bb, obj);
        Varint.writeUnsigned(bb, pred);
        Varint.writeUnsigned(bb, subj);
    }

    static boolean[] spocShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{subj > 0L, pred > 0L, obj > 0L, context >= 0L};
    }

    static boolean[] spcoShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{subj > 0L, pred > 0L, context >= 0L, obj > 0L};
    }

    static boolean[] sopcShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{subj > 0L, obj > 0L, pred > 0L, context >= 0L};
    }

    static boolean[] socpShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{subj > 0L, obj > 0L, context >= 0L, pred > 0L};
    }

    static boolean[] scpoShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{subj > 0L, context >= 0L, pred > 0L, obj > 0L};
    }

    static boolean[] scopShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{subj > 0L, context >= 0L, obj > 0L, pred > 0L};
    }

    static boolean[] psocShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{pred > 0L, subj > 0L, obj > 0L, context >= 0L};
    }

    static boolean[] pscoShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{pred > 0L, subj > 0L, context >= 0L, obj > 0L};
    }

    static boolean[] poscShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{pred > 0L, obj > 0L, subj > 0L, context >= 0L};
    }

    static boolean[] pocsShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{pred > 0L, obj > 0L, context >= 0L, subj > 0L};
    }

    static boolean[] pcsoShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{pred > 0L, context >= 0L, subj > 0L, obj > 0L};
    }

    static boolean[] pcosShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{pred > 0L, context >= 0L, obj > 0L, subj > 0L};
    }

    static boolean[] ospcShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{obj > 0L, subj > 0L, pred > 0L, context >= 0L};
    }

    static boolean[] oscpShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{obj > 0L, subj > 0L, context >= 0L, pred > 0L};
    }

    static boolean[] opscShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{obj > 0L, pred > 0L, subj > 0L, context >= 0L};
    }

    static boolean[] opcsShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{obj > 0L, pred > 0L, context >= 0L, subj > 0L};
    }

    static boolean[] ocspShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{obj > 0L, context >= 0L, subj > 0L, pred > 0L};
    }

    static boolean[] ocpsShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{obj > 0L, context >= 0L, pred > 0L, subj > 0L};
    }

    static boolean[] cspoShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{context >= 0L, subj > 0L, pred > 0L, obj > 0L};
    }

    static boolean[] csopShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{context >= 0L, subj > 0L, obj > 0L, pred > 0L};
    }

    static boolean[] cpsoShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{context >= 0L, pred > 0L, subj > 0L, obj > 0L};
    }

    static boolean[] cposShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{context >= 0L, pred > 0L, obj > 0L, subj > 0L};
    }

    static boolean[] cospShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{context >= 0L, obj > 0L, subj > 0L, pred > 0L};
    }

    static boolean[] copsShouldMatch(long subj, long pred, long obj, long context) {
        return new boolean[]{context >= 0L, obj > 0L, pred > 0L, subj > 0L};
    }

    @FunctionalInterface
    static interface BasicWriter {
        public void write(ByteBuffer var1, long var2, long var4, long var6, long var8);
    }

    private static final class CachingKeyWriter
    implements KeyWriter {
        private final Entry[] cache = new Entry[4096];
        private final BasicWriter basic;

        CachingKeyWriter(BasicWriter basic) {
            this.basic = basic;
        }

        @Override
        public void write(ByteBuffer bb, long subj, long pred, long obj, long context, boolean shouldCache) {
            if (!shouldCache) {
                this.basic.write(bb, subj, pred, obj, context);
                return;
            }
            long hashCode = subj - Long.MAX_VALUE + (pred - Long.MAX_VALUE) * 2L + (obj - Long.MAX_VALUE) * 3L + (context - Long.MAX_VALUE) * 4L;
            int slot = (int)(hashCode & 0xFFFL);
            Entry e = this.cache[slot];
            if (e != null && e.hashCode == hashCode && e.s == subj && e.p == pred && e.o == obj && e.c == context) {
                bb.put(e.bytes, 0, e.length);
                return;
            }
            int len = Varint.calcListLengthUnsigned(subj, pred, obj, context);
            byte[] bytes = new byte[len];
            ByteBuffer out = ByteBuffer.wrap(bytes);
            this.basic.write(out, subj, pred, obj, context);
            out.flip();
            bb.put(out);
            this.cache[slot] = new Entry(hashCode, subj, pred, obj, context, bytes);
        }

        private static final class Entry {
            final long hashCode;
            final long s;
            final long p;
            final long o;
            final long c;
            final byte[] bytes;
            final int length;

            Entry(long hashCode, long s, long p, long o, long c, byte[] bytes) {
                this.hashCode = hashCode;
                this.s = s;
                this.p = p;
                this.o = o;
                this.c = c;
                this.bytes = bytes;
                this.length = bytes.length;
            }
        }
    }

    @FunctionalInterface
    public static interface MatcherFactory {
        public boolean[] create(long var1, long var3, long var5, long var7);
    }

    @FunctionalInterface
    public static interface KeyWriter {
        public void write(ByteBuffer var1, long var2, long var4, long var6, long var8, boolean var10);
    }
}

