/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.concurrent.locks;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.ReadWriteLockManager;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.LockCleaner;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.LockDiagnostics;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.LockMonitoring;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.LockTracking;
import org.slf4j.LoggerFactory;

@Experimental
public class StampedLockManager
implements ReadWriteLockManager {
    private final LockMonitoring<ReadLock> readLockMonitoring;
    private final LockMonitoring<WriteLock> writeLockMonitoring;
    final StampedLock stampedLock = new StampedLock();
    private final int tryWriteLockMillis;

    public StampedLockManager() {
        this(false);
    }

    public StampedLockManager(boolean trackLocks) {
        this(trackLocks, 10000);
    }

    public StampedLockManager(boolean trackLocks, int waitToCollect) {
        this("", waitToCollect, LockDiagnostics.fromLegacyTracking(trackLocks));
    }

    public StampedLockManager(String alias, LockDiagnostics ... lockDiagnostics) {
        this(alias, 10000, lockDiagnostics);
    }

    public StampedLockManager(String alias, int waitToCollect, LockDiagnostics ... lockDiagnostics) {
        this.tryWriteLockMillis = Math.min(1000, waitToCollect);
        boolean releaseAbandoned = false;
        boolean detectStalledOrDeadlock = false;
        boolean stackTrace = false;
        block5: for (LockDiagnostics lockDiagnostic : lockDiagnostics) {
            switch (lockDiagnostic) {
                case releaseAbandoned: {
                    releaseAbandoned = true;
                    continue block5;
                }
                case detectStalledOrDeadlock: {
                    detectStalledOrDeadlock = true;
                    continue block5;
                }
                case stackTrace: {
                    stackTrace = true;
                }
            }
        }
        if (lockDiagnostics.length == 0) {
            this.readLockMonitoring = LockMonitoring.wrap(Lock.ExtendedSupplier.wrap(this::createReadLockInner, this::tryReadLockInner));
            this.writeLockMonitoring = LockMonitoring.wrap(Lock.ExtendedSupplier.wrap(this::createWriteLockInner, this::tryWriteLockInner));
        } else if (releaseAbandoned && !detectStalledOrDeadlock) {
            this.readLockMonitoring = new LockCleaner<ReadLock>(stackTrace, alias + "_READ", LoggerFactory.getLogger(this.getClass()), Lock.ExtendedSupplier.wrap(this::createReadLockInner, this::tryReadLockInner));
            this.writeLockMonitoring = new LockCleaner<WriteLock>(stackTrace, alias + "_WRITE", LoggerFactory.getLogger(this.getClass()), Lock.ExtendedSupplier.wrap(this::createWriteLockInner, this::tryWriteLockInner));
        } else {
            this.readLockMonitoring = new LockTracking<ReadLock>(stackTrace, alias + "_READ", LoggerFactory.getLogger(this.getClass()), waitToCollect, Lock.ExtendedSupplier.wrap(this::createReadLockInner, this::tryReadLockInner));
            this.writeLockMonitoring = new LockTracking<WriteLock>(stackTrace, alias + "_WRITE", LoggerFactory.getLogger(this.getClass()), waitToCollect, Lock.ExtendedSupplier.wrap(this::createWriteLockInner, this::tryWriteLockInner));
        }
    }

    @Override
    public boolean isWriterActive() {
        return this.stampedLock.isWriteLocked();
    }

    @Override
    public boolean isReaderActive() {
        return this.stampedLock.isReadLocked();
    }

    @Override
    public void waitForActiveWriter() throws InterruptedException {
        while (this.isWriterActive()) {
            this.spinWait();
        }
    }

    @Override
    public void waitForActiveReaders() throws InterruptedException {
        while (this.isReaderActive()) {
            this.spinWait();
        }
    }

    @Override
    public Lock getReadLock() throws InterruptedException {
        return this.readLockMonitoring.getLock();
    }

    private ReadLock createReadLockInner() throws InterruptedException {
        return new ReadLock(this.stampedLock, this.stampedLock.readLockInterruptibly());
    }

    public OptimisticReadLock getOptimisticReadLock() {
        long optimisticReadStamp = this.stampedLock.tryOptimisticRead();
        if (optimisticReadStamp != 0L) {
            return new OptimisticReadLock(this.stampedLock, optimisticReadStamp);
        }
        return null;
    }

    public Lock convertToReadLock(Lock writeLock) {
        WriteLock innerWriteLock = this.writeLockMonitoring.unsafeInnerLock(writeLock);
        long readLockStamp = this.stampedLock.tryConvertToReadLock(innerWriteLock.stamp);
        innerWriteLock.stamp = 0L;
        if (readLockStamp == 0L) {
            throw new IllegalMonitorStateException("Lock is not a locked write lock.");
        }
        ReadLock readLock = new ReadLock(this.stampedLock, readLockStamp);
        try {
            Lock registered = this.readLockMonitoring.register(readLock);
            this.writeLockMonitoring.unregister(writeLock);
            return registered;
        }
        catch (Throwable t) {
            readLock.release();
            throw t;
        }
    }

    @Override
    public Lock getWriteLock() throws InterruptedException {
        return this.writeLockMonitoring.getLock();
    }

    private WriteLock createWriteLockInner() throws InterruptedException {
        long writeStamp = this.writeLockInterruptibly();
        return new WriteLock(this.stampedLock, writeStamp);
    }

    private long writeLockInterruptibly() throws InterruptedException {
        if (this.writeLockMonitoring.requiresManualCleanup()) {
            long writeStamp;
            do {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                writeStamp = this.stampedLock.tryWriteLock(this.tryWriteLockMillis, TimeUnit.MILLISECONDS);
                if (writeStamp != 0L) continue;
                this.writeLockMonitoring.runCleanup();
                this.readLockMonitoring.runCleanup();
            } while (writeStamp == 0L);
            return writeStamp;
        }
        return this.stampedLock.writeLockInterruptibly();
    }

    @Override
    public Lock tryReadLock() {
        return this.readLockMonitoring.tryLock();
    }

    private ReadLock tryReadLockInner() {
        long stamp = this.stampedLock.tryReadLock();
        if (stamp != 0L) {
            return new ReadLock(this.stampedLock, stamp);
        }
        return null;
    }

    @Override
    public Lock tryWriteLock() {
        return this.writeLockMonitoring.tryLock();
    }

    private WriteLock tryWriteLockInner() {
        long stamp = this.stampedLock.tryWriteLock();
        if (stamp != 0L) {
            return new WriteLock(this.stampedLock, stamp);
        }
        return null;
    }

    private void spinWait() throws InterruptedException {
        Thread.onSpinWait();
        this.writeLockMonitoring.runCleanup();
        this.readLockMonitoring.runCleanup();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    private static class ReadLock
    implements Lock {
        private final StampedLock stampedLock;
        private final long stamp;
        private boolean locked = true;

        public ReadLock(StampedLock stampedLock, long stamp) {
            this.stampedLock = stampedLock;
            this.stamp = stamp;
        }

        @Override
        public boolean isActive() {
            return this.locked;
        }

        @Override
        public void release() {
            if (!this.locked) {
                throw new IllegalMonitorStateException("Trying to release a lock that is not locked");
            }
            this.locked = false;
            this.stampedLock.unlockRead(this.stamp);
        }
    }

    public static class OptimisticReadLock
    implements Lock {
        private final StampedLock stampedLock;
        private final long optimisticReadStamp;

        public OptimisticReadLock(StampedLock stampedLock, long stamp) {
            this.stampedLock = stampedLock;
            this.optimisticReadStamp = stamp;
        }

        @Override
        public boolean isActive() {
            return this.stampedLock.validate(this.optimisticReadStamp);
        }

        @Override
        public void release() {
        }
    }

    private static class WriteLock
    implements Lock {
        private final StampedLock lock;
        private long stamp;

        public WriteLock(StampedLock lock, long stamp) {
            assert (stamp != 0L);
            this.lock = lock;
            this.stamp = stamp;
        }

        @Override
        public boolean isActive() {
            return this.stamp != 0L;
        }

        @Override
        public void release() {
            long temp = this.stamp;
            this.stamp = 0L;
            if (temp == 0L) {
                throw new IllegalMonitorStateException("Trying to release a lock that is not locked");
            }
            this.lock.unlockWrite(temp);
        }
    }

    public static class Cache<T> {
        private final Supplier<T> dataSupplier;
        private volatile T data;
        private final StampedLockManager stampedLockManager;

        public Cache(StampedLockManager stampedLockManager, Supplier<T> dataSupplier) {
            this.dataSupplier = dataSupplier;
            this.stampedLockManager = stampedLockManager;
        }

        public ReadableState getReadState() throws InterruptedException {
            Lock readLock = this.refreshCacheIfNeeded(this.stampedLockManager.getReadLock());
            return new ReadableState(this.data, readLock);
        }

        private Lock refreshCacheIfNeeded(Lock readLock) throws InterruptedException {
            if (this.data == null) {
                readLock.release();
                Lock writeLock = this.stampedLockManager.getWriteLock();
                try {
                    if (this.data == null) {
                        this.data = this.dataSupplier.get();
                    }
                    readLock = this.stampedLockManager.convertToReadLock(writeLock);
                }
                catch (Throwable t) {
                    if (writeLock.isActive()) {
                        writeLock.release();
                    }
                    throw t;
                }
            }
            return readLock;
        }

        private void refreshCacheIfNeeded() throws InterruptedException {
            if (this.data == null) {
                Lock writeLock = null;
                try {
                    writeLock = this.stampedLockManager.getWriteLock();
                    if (this.data == null) {
                        this.data = this.dataSupplier.get();
                    }
                }
                finally {
                    if (writeLock != null) {
                        writeLock.release();
                    }
                }
            }
        }

        public WritableState getWriteState() throws InterruptedException {
            Lock writeLock = this.stampedLockManager.getWriteLock();
            return new WritableState(writeLock);
        }

        public OptimisticState getOptimisticState() throws InterruptedException {
            this.refreshCacheIfNeeded();
            OptimisticReadLock optimisticReadLock = this.stampedLockManager.getOptimisticReadLock();
            if (optimisticReadLock == null) {
                return new OptimisticState();
            }
            return new OptimisticState(this.data, this.stampedLockManager, optimisticReadLock);
        }

        public void warmUp() throws InterruptedException {
            assert (this.data == null);
            try (WritableState writeState = this.getWriteState();){
                Object data = writeState.getData();
                assert (this.data != null);
                assert (this.data == data);
            }
        }

        public class ReadableState
        implements AutoCloseable {
            T data;
            Lock readLock;

            ReadableState(T data, Lock readLock) {
                this.data = data;
                this.readLock = readLock;
            }

            @Override
            public void close() {
                this.readLock.release();
            }

            public T getData() {
                if (!this.readLock.isActive()) {
                    throw new IllegalMonitorStateException("Read lock has been released");
                }
                return this.data;
            }

            public T getDataAndRelease() {
                if (!this.readLock.isActive()) {
                    throw new IllegalMonitorStateException("Read lock has been released");
                }
                this.readLock.release();
                return this.data;
            }
        }

        public class WritableState
        implements AutoCloseable {
            Lock writeLock;
            private boolean purged;

            WritableState(Lock writeLock) {
                this.writeLock = writeLock;
            }

            public void purge() {
                if (!this.writeLock.isActive()) {
                    throw new IllegalMonitorStateException("Write lock has been released");
                }
                this.purged = true;
                Cache.this.data = null;
            }

            T getData() {
                if (!this.writeLock.isActive()) {
                    throw new IllegalMonitorStateException("Write lock has been released");
                }
                if (this.purged) {
                    throw new IllegalMonitorStateException("Cache was previously purged by this object.");
                }
                if (Cache.this.data == null) {
                    Cache.this.data = Cache.this.dataSupplier.get();
                }
                assert (Cache.this.data != null);
                return Cache.this.data;
            }

            @Override
            public void close() {
                this.writeLock.release();
            }
        }

        public class OptimisticState {
            T data;
            StampedLockManager stampedLockManager;
            OptimisticReadLock lock;

            OptimisticState(T data, StampedLockManager stampedLockManager, OptimisticReadLock lock) {
                this.data = data;
                assert (this.data != null);
                this.stampedLockManager = stampedLockManager;
                this.lock = lock;
            }

            public OptimisticState() {
                this.data = null;
                this.stampedLockManager = null;
                this.lock = null;
            }

            public boolean isValid() {
                return this.lock != null && this.lock.isActive();
            }

            public T getData() {
                assert (this.isValid());
                return this.data;
            }
        }
    }
}

