/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.trix;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.eclipse.rdf4j.common.io.CharSink;
import org.eclipse.rdf4j.common.xml.XMLWriter;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFWriter;
import org.eclipse.rdf4j.rio.helpers.XMLWriterSettings;

public class TriXWriter
extends AbstractRDFWriter
implements CharSink {
    private final XMLWriter xmlWriter;
    private boolean inActiveContext = false;
    private boolean convertRDFStar;
    private Resource currentContext = null;

    public TriXWriter(OutputStream out) {
        this.xmlWriter = new XMLWriter(out);
        this.xmlWriter.setPrettyPrint(true);
    }

    public TriXWriter(Writer writer) {
        this(new XMLWriter(writer));
    }

    protected TriXWriter(XMLWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
        this.xmlWriter.setPrettyPrint(true);
    }

    public Writer getWriter() {
        return this.xmlWriter.getWriter();
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.TRIX;
    }

    public void startRDF() throws RDFHandlerException {
        super.startRDF();
        try {
            if (((Boolean)this.getWriterConfig().get((RioSetting)XMLWriterSettings.INCLUDE_XML_PI)).booleanValue()) {
                this.xmlWriter.startDocument();
            }
            this.xmlWriter.setAttribute("xmlns", "http://www.w3.org/2004/03/trix/trix-1/");
            this.xmlWriter.startTag("TriX");
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void endRDF() throws RDFHandlerException {
        this.checkWritingStarted();
        try {
            if (this.inActiveContext) {
                this.xmlWriter.endTag("graph");
                this.inActiveContext = false;
                this.currentContext = null;
            }
            this.xmlWriter.endTag("TriX");
            this.xmlWriter.endDocument();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleNamespace(String prefix, String name) {
        this.checkWritingStarted();
    }

    protected void consumeStatement(Statement st) {
        try {
            Resource context = st.getContext();
            if (this.inActiveContext && !TriXWriter.contextsEquals(context, this.currentContext)) {
                this.xmlWriter.endTag("graph");
                this.inActiveContext = false;
            }
            if (!this.inActiveContext) {
                this.xmlWriter.startTag("graph");
                if (context != null) {
                    this.writeValue((Value)context);
                }
                this.currentContext = context;
                this.inActiveContext = true;
            }
            this.xmlWriter.startTag("triple");
            this.writeValue((Value)st.getSubject());
            this.writeValue((Value)st.getPredicate());
            this.writeValue(st.getObject());
            this.xmlWriter.endTag("triple");
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
        this.checkWritingStarted();
        try {
            this.xmlWriter.comment(comment);
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    private void writeValue(Value value) throws IOException, RDFHandlerException {
        if (value instanceof IRI) {
            IRI uri = (IRI)value;
            this.xmlWriter.textElement("uri", uri.toString());
        } else if (value instanceof BNode) {
            BNode bNode = (BNode)value;
            this.xmlWriter.textElement("id", bNode.getID());
        } else if (value instanceof Literal) {
            Literal literal = (Literal)value;
            IRI datatype = literal.getDatatype();
            if (Literals.isLanguageLiteral((Literal)literal)) {
                this.xmlWriter.setAttribute("xml:lang", (String)literal.getLanguage().get());
                this.xmlWriter.textElement("plainLiteral", literal.getLabel());
            } else {
                this.xmlWriter.setAttribute("datatype", datatype.toString());
                this.xmlWriter.textElement("typedLiteral", literal.getLabel());
            }
        } else {
            throw new RDFHandlerException("Unknown value type: " + String.valueOf(value.getClass()));
        }
    }

    private static boolean contextsEquals(Resource context1, Resource context2) {
        if (context1 == null) {
            return context2 == null;
        }
        return context1.equals((Object)context2);
    }
}

