/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.gef;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.rcptt.tesla.gef.GefProcessor;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.swt.IRecorderDescriberExtension;
import org.eclipse.rcptt.tesla.recording.core.swt.IRecordingDescriber;
import org.eclipse.rcptt.tesla.recording.core.swt.RecordingWidgetDescriber;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTEventRecorder;
import org.eclipse.rcptt.tesla.recording.gef.RecordingEditPartDescriber;
import org.eclipse.rcptt.tesla.recording.gef.RecordingFigureDescriber;
import org.eclipse.swt.widgets.Widget;

public class GEFDescriberRecorderExtension
implements IRecorderDescriberExtension {
    private SWTEventRecorder swtProcessor;

    private IFigure skipFlowFigures(IFigure figureAt, IFigure figure) {
        while (figureAt instanceof FlowFigure) {
            if (figure.equals(figureAt = figureAt.getParent())) break;
        }
        return figureAt;
    }

    public IRecordingDescriber getDescriber(Widget widget, IRecordingDescriber previous, int x, int y, boolean fromAsser) {
        if (widget instanceof FigureCanvas) {
            EditPart editPart;
            FigureCanvas canvas = (FigureCanvas)widget;
            SWTUIPlayer player = this.getSWTProcessor(TeslaRecorder.getInstance()).getPlayer();
            GraphicalViewer viewer = GefProcessor.findDiagramViewer((SWTUIElement)player.wrap((Object)canvas), GraphicalViewer.class, null);
            EditPart editPart2 = editPart = viewer == null ? null : viewer.findObjectAt(new Point(x, y));
            if (editPart instanceof RootEditPart) {
                return new RecordingEditPartDescriber(viewer.getContents(), viewer);
            }
            if (editPart != null) {
                FigureCanvas figureCanvas;
                IFigure figure = ((GraphicalEditPart)editPart).getFigure();
                IFigure figureAt = null;
                Point location = null;
                if (viewer != null && (figureCanvas = (FigureCanvas)viewer.getControl()) != null) {
                    location = figureCanvas.getViewport().getViewLocation();
                }
                if ((figureAt = location != null ? figure.findFigureAt(x + location.x, y + location.y) : figure.findFigureAt(x, y)) != null && !figure.equals(figureAt)) {
                    figureAt = this.skipFlowFigures(figureAt, figure);
                    return new RecordingFigureDescriber(figureAt, editPart, viewer, canvas);
                }
                return new RecordingEditPartDescriber(editPart, viewer);
            }
        }
        if (previous != null) {
            return previous;
        }
        return new RecordingWidgetDescriber(widget);
    }

    private SWTEventRecorder getSWTProcessor(TeslaRecorder recorder) {
        if (this.swtProcessor == null) {
            this.swtProcessor = (SWTEventRecorder)recorder.getProcessor(SWTEventRecorder.class);
        }
        return this.swtProcessor;
    }
}

