/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.transport.ecf;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.filetransfer.IRemoteFile;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemBrowserContainerAdapter;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemRequest;
import org.eclipse.ecf.filetransfer.RemoteFileSystemException;
import org.eclipse.ecf.filetransfer.events.IRemoteFileSystemBrowseEvent;
import org.eclipse.ecf.filetransfer.identity.FileCreateException;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.repository.JREHttpClientRequiredException;
import org.eclipse.equinox.internal.p2.repository.Messages;
import org.eclipse.equinox.internal.p2.repository.RepositoryPreferences;
import org.eclipse.equinox.internal.p2.transport.ecf.RepositoryStatusHelper;
import org.eclipse.osgi.util.NLS;

class FileInfoReader {
    private final int connectionRetryCount = RepositoryPreferences.getConnectionRetryCount();
    private final long connectionRetryDelay = RepositoryPreferences.getConnectionMsRetryDelay();
    private final IConnectContext connectContext;

    FileInfoReader(IConnectContext aConnectContext) {
        this.connectContext = aConnectContext;
    }

    long getLastModified(URI uri, IProgressMonitor monitor) throws AuthenticationFailedException, FileNotFoundException, CoreException, JREHttpClientRequiredException {
        IContainer container;
        SubMonitor convert = SubMonitor.convert((IProgressMonitor)monitor, (String)uri.toString(), (int)this.connectionRetryCount);
        try {
            container = ContainerFactory.getDefault().createContainer();
        }
        catch (ContainerCreateException e) {
            throw RepositoryStatusHelper.fromExceptionMessage(e, Messages.ecf_configuration_error);
        }
        IRemoteFileSystemBrowserContainerAdapter adapter = (IRemoteFileSystemBrowserContainerAdapter)container.getAdapter(IRemoteFileSystemBrowserContainerAdapter.class);
        if (adapter == null) {
            throw RepositoryStatusHelper.fromMessage(Messages.ecf_configuration_error);
        }
        adapter.setConnectContextForAuthentication(this.connectContext);
        CoreException summary = new CoreException(Status.error((String)"All download attempts failed"));
        int retryCount = 0;
        while (retryCount < this.connectionRetryCount) {
            if (convert.isCanceled()) {
                throw new OperationCanceledException();
            }
            AtomicReference remote = new AtomicReference();
            AtomicReference<Throwable> exception = new AtomicReference<Throwable>();
            try {
                IFileID fileID = FileIDFactory.getDefault().createFileID(adapter.getBrowseNamespace(), uri.toString());
                CountDownLatch latch = new CountDownLatch(1);
                IRemoteFileSystemRequest browseRequest = adapter.sendBrowseRequest(fileID, event -> {
                    Exception e = event.getException();
                    if (e != null) {
                        exception.set(e);
                    } else if (event instanceof IRemoteFileSystemBrowseEvent) {
                        IRemoteFileSystemBrowseEvent fsbe = (IRemoteFileSystemBrowseEvent)event;
                        IRemoteFile[] remoteFiles = fsbe.getRemoteFiles();
                        if (remoteFiles != null && remoteFiles.length > 0) {
                            remote.set(remoteFiles[0]);
                        }
                        convert.worked(1);
                    }
                    latch.countDown();
                });
                while (!latch.await(1L, TimeUnit.SECONDS)) {
                    if (!convert.isCanceled()) continue;
                    browseRequest.cancel();
                    throw new OperationCanceledException();
                }
            }
            catch (RemoteFileSystemException | FileCreateException e) {
                exception.set(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.repository", "Unexpected interrupt while waiting on ECF browse request", (Throwable)e));
                throw new OperationCanceledException();
            }
            Exception e = (Exception)exception.get();
            if (e == null) {
                IRemoteFile remoteFile = (IRemoteFile)remote.get();
                if (remoteFile == null) {
                    throw new FileNotFoundException(uri.toString());
                }
                return remoteFile.getInfo().getLastModified();
            }
            this.checkException(uri, retryCount, e);
            summary.addSuppressed((Throwable)e);
            ++retryCount;
        }
        throw summary;
    }

    private boolean checkException(URI uri, int attemptCounter, Exception exception) throws CoreException, FileNotFoundException, AuthenticationFailedException, JREHttpClientRequiredException {
        RepositoryStatusHelper.checkJREHttpClientRequired(exception);
        RepositoryStatusHelper.checkPermissionDenied(exception);
        RepositoryStatusHelper.checkFileNotFound(exception, uri);
        Throwable t = RepositoryStatusHelper.unwind(exception);
        if (t instanceof CoreException) {
            throw RepositoryStatusHelper.unwindCoreException((CoreException)t);
        }
        if (t instanceof IOException && attemptCounter < this.connectionRetryCount - 1) {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.repository", NLS.bind((String)Messages.connection_to_0_failed_on_1_retry_attempt_2, (Object[])new String[]{uri.toString(), t.getMessage(), String.valueOf(attemptCounter)}), t));
            try {
                Thread.sleep(this.connectionRetryDelay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new OperationCanceledException();
            }
        }
        throw RepositoryStatusHelper.wrap(exception);
    }
}

