/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.preferences;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.rcptt.core.Q7;
import org.eclipse.rcptt.core.Q7Features;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.launching.Q7Launcher;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.utils.AbstractFeatureManager;
import org.eclipse.rcptt.ui.preferences.FeaturesComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class Q7PreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text textLaunchTimeout;
    private Text textCommandsDelay;
    private FeaturesComposite features = new FeaturesComposite();
    private static final List<String> DISABLED_OPTIONS = Arrays.asList("org.eclipse.rcptt.tesla.protocol.version");
    private static final String[] TRIM_PREFIXES = new String[]{"ui", "org.eclipse.rcptt.tesla.protocol.", "org.eclipse.rcptt.tesla.", "com.xored."};

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.textLaunchTimeout = this.createText(composite, Messages.Q7PreferencePage_LaunchTimeoutLabel, Integer.toString(Q7Launcher.getLaunchTimeout()));
        this.textCommandsDelay = this.createText(composite, Messages.Q7PreferencePage_CommandDelayLabel, Integer.toString(Q7.INSTANCE.getCommandsExecutionDelay()));
        ExpandableComposite advancedExpander = new ExpandableComposite(parent, 0, 2);
        advancedExpander.setText(Messages.Q7PreferencePage_AdvancedSectionLabel);
        advancedExpander.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite advancedComposite = new Composite((Composite)advancedExpander, 0);
        advancedComposite.setLayout((Layout)new GridLayout(1, false));
        advancedExpander.setClient((Control)advancedComposite);
        Link runnerArg = new Link(advancedComposite, 0);
        runnerArg.setLayoutData((Object)new GridData(131072, -1, true, false, 2, 1));
        runnerArg.setText(Messages.Q7PreferencePage_AdvancedRunnerArgLink);
        runnerArg.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new MessageDialog(Q7PreferencePage.this.getShell(), "-testOptions arg for RCPTT Runner", null, Q7PreferencePage.this.buildTestOptionsLine(), 2, new String[]{"Copy to Clipboard", "Close"}, 1){

                    protected void buttonPressed(int buttonId) {
                        switch (buttonId) {
                            case 0: {
                                Clipboard cb = new Clipboard(this.getShell().getDisplay());
                                cb.setContents(new Object[]{this.message}, new Transfer[]{TextTransfer.getInstance()});
                                cb.dispose();
                                break;
                            }
                            default: {
                                super.buttonPressed(buttonId);
                            }
                        }
                    }
                }.open();
            }
        });
        final Control control = this.features.createOptions(advancedComposite, "adv.options", false, null);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(control);
        advancedExpander.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
            }

            public void expansionStateChanged(ExpansionEvent e) {
                if (e.getState()) {
                    control.setFocus();
                }
            }
        });
        return null;
    }

    private void validate() {
        String message = this.doValidate();
        this.setErrorMessage(message);
        this.setValid(message == null);
    }

    private String doValidate() {
        if (!this.isPositiveInteger(this.textLaunchTimeout.getText())) {
            return Messages.Q7PreferencePage_IncorrectLaunchTimeoutMsg;
        }
        if (!this.isPositiveInteger(this.textCommandsDelay.getText())) {
            return Messages.Q7PreferencePage_IncorrectCommandDelayMsg;
        }
        return null;
    }

    private boolean isPositiveInteger(String value) {
        try {
            if (Integer.parseInt(value) >= 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private Text createText(Composite parent, String labelText, String initialValue) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        Text text = new Text(parent, 2048);
        text.setText(initialValue);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Q7PreferencePage.this.validate();
            }
        });
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    public boolean performOk() {
        Q7Launcher.setLaunchTimeout((int)Integer.parseInt(this.textLaunchTimeout.getText()));
        Q7.INSTANCE.setCommandsExecutionDelay(Integer.parseInt(this.textCommandsDelay.getText()));
        this.features.apply();
        return super.performOk();
    }

    protected void performDefaults() {
        this.textLaunchTimeout.setText(Integer.toString(300));
        this.textCommandsDelay.setText(Integer.toString(0));
        this.features.setDefaults();
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }

    private String buildTestOptionsLine() {
        AbstractFeatureManager[] managers = new AbstractFeatureManager[]{TeslaFeatures.getInstance(), Q7Features.getInstance()};
        LinkedHashMap<String, AbstractFeatureManager.Option> nonDefaultOptions = new LinkedHashMap<String, AbstractFeatureManager.Option>();
        AbstractFeatureManager[] abstractFeatureManagerArray = managers;
        int n = managers.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractFeatureManager manager = abstractFeatureManagerArray[n2];
            String[] stringArray = manager.getOptionNames();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                AbstractFeatureManager.Option option;
                String optionKey = stringArray[n4];
                if (!DISABLED_OPTIONS.contains(optionKey) && ((option = manager.getOption(optionKey)).getValue() == null && option.getDefaultValue() != null || !option.getValue().equals(option.getDefaultValue()))) {
                    nonDefaultOptions.put(optionKey, option);
                }
                ++n4;
            }
            ++n2;
        }
        if (nonDefaultOptions.size() == 0) {
            return "All options are set to defaults, no need to specify -testOptions arg";
        }
        StringBuilder result = new StringBuilder();
        result.append("-testOptions ");
        for (Map.Entry option : nonDefaultOptions.entrySet()) {
            result.append(String.format("%s=%s;", Q7PreferencePage.optionNameToArgName((String)option.getKey()), ((AbstractFeatureManager.Option)option.getValue()).getValue()));
        }
        result.setLength(result.length() - 1);
        return result.toString();
    }

    private static final String optionNameToArgName(String optionName) {
        StringBuilder result = new StringBuilder();
        String[] stringArray = TRIM_PREFIXES;
        int n = TRIM_PREFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (optionName.startsWith(prefix)) {
                optionName = optionName.substring(prefix.length());
                break;
            }
            ++n2;
        }
        String[] parts = optionName.split("\\.");
        boolean isFirst = true;
        String[] stringArray2 = parts;
        int n3 = parts.length;
        int n4 = 0;
        while (n4 < n3) {
            String part = stringArray2[n4];
            if (part.length() != 0) {
                if (isFirst) {
                    isFirst = false;
                    result.append(part);
                } else {
                    result.append(Character.toUpperCase(part.charAt(0)));
                    result.append(part.substring(1));
                }
            }
            ++n4;
        }
        return result.toString();
    }
}

