/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.repository.tree.AdditionalRefNode;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.StashedCommitNode;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IEvaluationService;

public class OpenInCommitViewerCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode>
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        for (RepositoryTreeNode node : this.getSelectedNodes(event)) {
            RepositoryCommit commit = null;
            try {
                if (node instanceof RefNode || node instanceof AdditionalRefNode) {
                    Ref ref = (Ref)node.getObject();
                    repo = node.getRepository();
                    ref = repo.exactRef(ref.getName());
                    if (ref != null) {
                        commit = new RepositoryCommit(repo, repo.parseCommit((AnyObjectId)ref.getObjectId()));
                    }
                } else if (node instanceof TagNode) {
                    String oid = ((TagNode)node).getCommitId();
                    if (oid != null) {
                        repo = node.getRepository();
                        commit = new RepositoryCommit(repo, repo.parseCommit((AnyObjectId)ObjectId.fromString((String)oid)));
                    }
                } else if (node instanceof StashedCommitNode) {
                    commit = new RepositoryCommit(node.getRepository(), (RevCommit)((StashedCommitNode)node).getObject());
                    commit.setStash(true);
                }
            }
            catch (IOException e) {
                Activator.logError(e.getLocalizedMessage(), e);
            }
            if (commit == null) continue;
            CommitEditor.openQuiet(commit);
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IStructuredSelection selection = SelectionUtils.getSelection(((IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class)).getCurrentState());
        if (selection.size() > 1) {
            element.setText(UIText.RepositoriesView_OpenAllInCommitViewerLabel);
        }
    }
}

