/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.dialogs;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.swt.widgets.Shell;

public class AddProjectReferencesDialog
extends MessageDialogWithToggle {
    private static IPreferenceStore prefStore = Q7UIPlugin.getDefault().getPreferenceStore();
    private final Map<IProject, Set<IQ7NamedElement>> references;
    private final IProject project;
    private static AddProjectReferencesDialog instance;

    public static boolean open(Shell parentShell, IProject project, Map<IProject, Set<IQ7NamedElement>> references) {
        String value = prefStore.getString("add_project_references");
        if ("always".equals(value)) {
            AddProjectReferencesDialog.addMissingReferences(project, references);
            return true;
        }
        if (instance != null && instance.getShell() != null && !instance.getShell().isDisposed()) {
            return false;
        }
        instance = new AddProjectReferencesDialog(parentShell, project, references);
        return instance.open() == 2;
    }

    private AddProjectReferencesDialog(Shell parentShell, IProject project, Map<IProject, Set<IQ7NamedElement>> references) {
        super(parentShell, Messages.AddProjectReferencesDialog_Title, null, null, 0, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, Messages.AddProjectReferencesDialog_ToggleText, false);
        this.project = project;
        this.references = references;
        this.message = this.generateMessage(references);
        this.setShellStyle(0x10000000);
    }

    private String generateMessage(Map<IProject, Set<IQ7NamedElement>> references) {
        StringBuilder label = new StringBuilder(Messages.AddProjectReferencesDialog_Msg);
        for (IProject p : references.keySet()) {
            label.append("    ").append(p.getName()).append("\n");
        }
        return label.toString();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 2) {
            AddProjectReferencesDialog.addMissingReferences(this.project, this.references);
        }
        if (this.getToggleState()) {
            prefStore.setValue("add_project_references", "always");
        }
        this.setReturnCode(buttonId);
        this.close();
    }

    private static void addMissingReferences(final IProject project, final Map<IProject, Set<IQ7NamedElement>> references) {
        Job job = new Job(Messages.AddProjectReferencesDialog_Job){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IProjectDescription description = project.getDescription();
                    IProject[] referenced = project.getReferencedProjects();
                    IProject[] newReferenced = new IProject[referenced.length + references.size()];
                    System.arraycopy(referenced, 0, newReferenced, 0, referenced.length);
                    int i = referenced.length;
                    for (IProject d : references.keySet()) {
                        newReferenced[i++] = d;
                    }
                    description.setReferencedProjects(newReferenced);
                    project.setDescription(description, monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

