/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.platform.objects;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PluginState implements Enumerator
{
    UNINSTALLED(0, "UNINSTALLED", "UNINSTALLED"),
    INSTALLED(1, "INSTALLED", "INSTALLED"),
    RESOLVED(2, "RESOLVED", "RESOLVED"),
    STARTING(3, "STARTING", "STARTING"),
    STOPPING(4, "STOPPING", "STOPPING"),
    ACTIVE(5, "ACTIVE", "ACTIVE");

    public static final int UNINSTALLED_VALUE = 0;
    public static final int INSTALLED_VALUE = 1;
    public static final int RESOLVED_VALUE = 2;
    public static final int STARTING_VALUE = 3;
    public static final int STOPPING_VALUE = 4;
    public static final int ACTIVE_VALUE = 5;
    private static final PluginState[] VALUES_ARRAY;
    public static final List<PluginState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PluginState[]{UNINSTALLED, INSTALLED, RESOLVED, STARTING, STOPPING, ACTIVE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PluginState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PluginState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PluginState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PluginState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PluginState get(int value) {
        switch (value) {
            case 0: {
                return UNINSTALLED;
            }
            case 1: {
                return INSTALLED;
            }
            case 2: {
                return RESOLVED;
            }
            case 3: {
                return STARTING;
            }
            case 4: {
                return STOPPING;
            }
            case 5: {
                return ACTIVE;
            }
        }
        return null;
    }

    private PluginState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

