/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.processors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.rcptt.tesla.core.protocol.BooleanResponse;
import org.eclipse.rcptt.tesla.core.protocol.DragCommand;
import org.eclipse.rcptt.tesla.core.protocol.DragKind;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.raw.RawFactory;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.core.protocol.raw.ResponseStatus;
import org.eclipse.rcptt.tesla.internal.core.AbstractTeslaClient;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.ui.player.EventBuilder;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.internal.ui.processors.DNDEventAdapter;
import org.eclipse.rcptt.tesla.internal.ui.processors.SWTUIProcessor;
import org.eclipse.rcptt.tesla.swt.dnd.DNDManager;
import org.eclipse.rcptt.tesla.swt.events.TeslaEventManager;
import org.eclipse.rcptt.tesla.ui.describers.DescriberManager;
import org.eclipse.rcptt.tesla.ui.describers.IWidgetDescriber;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class DragSupport {
    private static final int DETAIL = 0;
    private static final int BUTTON = 1;
    private static final int MASK = 2;
    private static final int OPERATIONS = 3;
    private AbstractTeslaClient client;
    private String id;
    private DragSource currentSource;
    private DropTarget currentTarget;
    private Object currentData;
    private Object dataType;
    private int feedback;
    private Widget currentItem;

    public String getFeatureID() {
        return this.id;
    }

    public void initialize(AbstractTeslaClient client, String id) {
        this.client = client;
        this.id = id;
    }

    private static boolean isSourceRelated(DragKind kind) {
        return kind == DragKind.START || kind == DragKind.SET_DATA || kind == DragKind.END;
    }

    private static boolean isTargetRelated(DragKind kind) {
        return !DragSupport.isSourceRelated(kind);
    }

    private int[] parseStyleIntoStates(String style) {
        int[] states = new int[4];
        if (style != null) {
            String[] split;
            String[] stringArray = split = style.split(",");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String var = stringArray[n2];
                String[] strings = var.split(":");
                if (strings[0].equals("detail")) {
                    states[0] = Integer.parseInt(strings[1]);
                }
                if (strings[0].equals("button")) {
                    states[1] = Integer.parseInt(strings[1]);
                }
                if (strings[0].equals("mask")) {
                    states[2] = Integer.parseInt(strings[1]);
                }
                if (strings[0].equals("operations")) {
                    int ops = Integer.parseInt(strings[1]);
                    if (ops == -1) {
                        ops = this.currentSource != null && !this.currentSource.isDisposed() ? this.currentSource.getStyle() : 7;
                    }
                    states[3] = ops;
                }
                ++n2;
            }
        }
        return states;
    }

    private Widget getItem(DropTarget target, Point displayPoint) {
        DropTargetEffect effect = target.getDropTargetEffect();
        if (effect == null) {
            return null;
        }
        return effect.getItem(displayPoint.x, displayPoint.y);
    }

    public Response handleUniversalDrag(final DragCommand command) {
        Response response = RawFactory.eINSTANCE.createResponse();
        SWTUIProcessor processor = (SWTUIProcessor)this.client.getProcessor(SWTUIProcessor.class);
        SWTUIElement swtuiElement = (SWTUIElement)processor.getMapper().get(command.getElement());
        Widget widget = PlayerWrapUtils.unwrapWidget(swtuiElement);
        if (!(widget instanceof Control)) {
            response.setStatus(ResponseStatus.FAILED);
            response.setMessage("Widget is not a control.");
            return response;
        }
        final Control control = (Control)widget;
        this.getPlayer().exec("DND", new Runnable(){

            @Override
            public void run() {
                Integer x = command.getX();
                Integer y = command.getY();
                Rectangle bounds = control.getBounds();
                Point clientPoint = new Point(x == null ? bounds.width / 2 : x, y == null ? bounds.height / 2 : y);
                Point displayPoint = control.toDisplay(clientPoint);
                int[] states = DragSupport.this.parseStyleIntoStates(command.getStyle());
                switch (command.getKind()) {
                    case START: {
                        control.forceFocus();
                        DragSupport.this.currentSource = DragSupport.this.getDragSource((Widget)control);
                        DNDEventAdapter a = DragSupport.this.createDNDEvent(2008, (Widget)DragSupport.this.currentSource, clientPoint, states, null);
                        DragSupport.this.currentSource.notifyListeners(2008, (Event)a.getEvent());
                        break;
                    }
                    case ENTER: {
                        DragSupport.this.currentTarget = DragSupport.this.getDropTarget((Widget)control);
                        DNDEventAdapter a = DragSupport.this.createDNDEvent(2002, (Widget)DragSupport.this.currentTarget, displayPoint, states, DragSupport.this.getItem(DragSupport.this.currentTarget, displayPoint));
                        DragSupport.this.currentTarget.notifyListeners(2002, (Event)a.getEvent());
                        DragSupport.this.updateInfo(a);
                        break;
                    }
                    case OVER: {
                        DragSupport.this.currentTarget = DragSupport.this.getDropTarget((Widget)control);
                        DNDEventAdapter a = DragSupport.this.createDNDEvent(2004, (Widget)DragSupport.this.currentTarget, displayPoint, states, DragSupport.this.getItem(DragSupport.this.currentTarget, displayPoint));
                        DragSupport.this.currentTarget.notifyListeners(2004, (Event)a.getEvent());
                        DragSupport.this.updateInfo(a);
                        break;
                    }
                    case LEAVE: {
                        DragSupport.this.currentTarget = DragSupport.this.getDropTarget((Widget)control);
                        DNDEventAdapter a = DragSupport.this.createDNDEvent(2003, (Widget)DragSupport.this.currentTarget, displayPoint, states, DragSupport.this.currentItem);
                        DragSupport.this.currentTarget.notifyListeners(2003, (Event)a.getEvent());
                        break;
                    }
                    case ACCEPT: {
                        DragSupport.this.currentTarget = DragSupport.this.getDropTarget((Widget)control);
                        DNDEventAdapter a = DragSupport.this.createDNDEvent(2007, (Widget)DragSupport.this.currentTarget, displayPoint, states, DragSupport.this.getItem(DragSupport.this.currentTarget, displayPoint));
                        DragSupport.this.currentTarget.notifyListeners(2007, (Event)a.getEvent());
                        break;
                    }
                    case SET_DATA: {
                        DragSupport.this.doDragSetData((Widget)control, clientPoint, states);
                        break;
                    }
                    case DROP: {
                        DragSupport.this.currentTarget = DragSupport.this.getDropTarget((Widget)control);
                        DNDEventAdapter a = DragSupport.this.createDNDEvent(2006, (Widget)DragSupport.this.currentTarget, displayPoint, states, DragSupport.this.getItem(DragSupport.this.currentTarget, displayPoint));
                        new EventBuilder((Event)a.getEvent()).data(DragSupport.this.currentData).send((Widget)DragSupport.this.currentTarget);
                        break;
                    }
                    case END: {
                        DragSupport.this.currentSource = DragSupport.this.getDragSource((Widget)control);
                        DNDEventAdapter a = DragSupport.this.createDNDEvent(2000, (Widget)DragSupport.this.currentSource, clientPoint, states, null);
                        DragSupport.this.currentSource.notifyListeners(2000, (Event)a.getEvent());
                    }
                }
            }
        });
        return response;
    }

    public Response handleDrag(final DragCommand command) {
        Point point;
        IWidgetDescriber describer = DescriberManager.getDescriber(command.getElement(), this.client);
        if (describer == null) {
            return this.reportFailed("Failed to locate element for drag");
        }
        if (!describer.supportsDND()) {
            Widget commandWidget = describer.getWidget();
            if (DragSupport.isSourceRelated(command.getKind()) && this.getDragSource(commandWidget) != null || DragSupport.isTargetRelated(command.getKind()) && this.getDropTarget(commandWidget) != null) {
                return this.handleUniversalDrag(command);
            }
        }
        if ((point = describer.getRealPoint()) == null) {
            return this.reportFailed("Failed to locate element for drag");
        }
        Integer x = command.getX();
        Integer y = command.getY();
        point.x = point.x + (x == null ? describer.getBounds().width / 2 : x);
        point.y = point.y + (y == null ? (y = Integer.valueOf(describer.getBounds().height / 2)) : y);
        Control widget = (Control)describer.getControl().getWidget();
        if (command.getKind().equals((Object)DragKind.START) || command.getKind().equals((Object)DragKind.SET_DATA) || command.getKind().equals((Object)DragKind.END)) {
            point = widget.toControl(point);
        }
        if (point == null) {
            return RawFactory.eINSTANCE.createResponse();
        }
        final IWidgetDescriber controlDescriber = describer.getControl();
        final IWidgetDescriber itemDescriber = controlDescriber.equals(describer) ? null : describer;
        if (command.getKind().equals((Object)DragKind.LEAVE)) {
            point = new Point(0, 0);
        }
        final Point destinationPoint = point;
        final int[] states = this.parseStyleIntoStates(command.getStyle());
        switch (command.getKind()) {
            case ACCEPT: 
            case DROP: 
            case OVER: 
            case ENTER: {
                this.currentTarget = this.getDropTarget(controlDescriber.getWidget());
                if (this.currentTarget != null) break;
                Response response = RawFactory.eINSTANCE.createResponse();
                response.setStatus(ResponseStatus.FAILED);
                StringBuilder msg = new StringBuilder();
                msg.append("Failed to locate drag target.\n");
                msg.append("Widget selected as target is:" + describer.getWidget().getClass().getName());
                response.setMessage(msg.toString());
                return response;
            }
        }
        this.getPlayer().exec("DND", new Runnable(){

            @Override
            public void run() {
                if (itemDescriber != null) {
                    DragSupport.this.showItemBeforeDrag(itemDescriber);
                }
                switch (command.getKind()) {
                    case DETECT: {
                        DragSupport.this.doDragDetect(controlDescriber, destinationPoint);
                        break;
                    }
                    case START: {
                        DragSupport.this.doDragStart(controlDescriber, destinationPoint, states);
                        break;
                    }
                    case ACCEPT: {
                        DragSupport.this.doDragAccept(controlDescriber, itemDescriber, destinationPoint, states);
                        break;
                    }
                    case DROP: {
                        DragSupport.this.doDrop(controlDescriber, itemDescriber, destinationPoint, states);
                        break;
                    }
                    case OVER: {
                        DragSupport.this.doDragOver(controlDescriber, itemDescriber, destinationPoint, states);
                        break;
                    }
                    case ENTER: {
                        DragSupport.this.doDragEnter(controlDescriber, itemDescriber, destinationPoint, states);
                        break;
                    }
                    case LEAVE: {
                        DragSupport.this.doDragLeave(destinationPoint, states);
                        break;
                    }
                    case END: {
                        DragSupport.this.doDragEnd(controlDescriber, destinationPoint, states);
                        break;
                    }
                    case SET_DATA: {
                        DragSupport.this.doDragSetData(controlDescriber.getWidget(), destinationPoint, states);
                    }
                }
            }
        });
        return RawFactory.eINSTANCE.createResponse();
    }

    private void doDragDetect(IWidgetDescriber controlDescriber, Point destinationPoint) {
        Widget widget = controlDescriber.getWidget();
        if (widget instanceof Control) {
            ((Control)widget).forceFocus();
        }
        this.getPlayer().getEvents().sendEvent(widget, 29, destinationPoint.x, destinationPoint.y, 1);
    }

    private void doDragStart(IWidgetDescriber controlDescriber, Point destinationPoint, int[] states) {
        this.currentSource = this.getDragSource(controlDescriber.getWidget());
        this.currentSource.getControl().forceFocus();
        DNDEventAdapter event = this.createDNDEvent(destinationPoint, states, 2008);
        TeslaEventManager.getManager().setForceFocusControl(this.currentSource.getControl());
        this.getPlayer().getEvents().sendEvent((Widget)this.currentSource, (Event)event.getEvent());
        TeslaEventManager.getManager().setForceFocusControl(null);
    }

    private void doDragAccept(IWidgetDescriber controlDescriber, IWidgetDescriber itemDescriber, Point destinationPoint, int[] states) {
        this.currentTarget = this.getDropTarget(controlDescriber.getWidget());
        if (this.currentTarget != null) {
            DNDEventAdapter adapter = this.createDNDEvent(destinationPoint, states, 2007);
            Event e = (Event)adapter.getEvent();
            if (itemDescriber != null) {
                e.item = itemDescriber.getItemWidget();
            }
            this.currentTarget.getControl().forceFocus();
            this.getPlayer().getEvents().sendEvent((Widget)this.currentTarget, (Event)adapter.getEvent());
        }
    }

    private void doDrop(IWidgetDescriber controlDescriber, IWidgetDescriber itemDescriber, Point destinationPoint, int[] states) {
        Transfer[] transfers;
        if (this.currentSource != null && (transfers = this.currentSource.getTransfer()) != null) {
            Transfer[] transferArray = transfers;
            int n = transfers.length;
            int n2 = 0;
            while (n2 < n) {
                Transfer t = transferArray[n2];
                if (t.getClass().getName().equals("org.eclipse.emf.edit.ui.dnd.LocalTransfer")) {
                    TeslaSWTAccess.setField(t, "object", this.currentData);
                }
                ++n2;
            }
        }
        this.currentTarget = this.getDropTarget(controlDescriber.getWidget());
        if (this.currentTarget != null) {
            DNDEventAdapter adapter = this.createDNDEvent(destinationPoint, states, 2006);
            Event e = (Event)adapter.getEvent();
            if (itemDescriber != null) {
                e.item = itemDescriber.getItemWidget();
            }
            e.data = this.currentData;
            this.currentTarget.getControl().forceFocus();
            this.getPlayer().getEvents().sendEvent((Widget)this.currentTarget, (Event)adapter.getEvent());
        }
    }

    private void doDragOver(IWidgetDescriber controlDescriber, IWidgetDescriber itemDescriber, Point destinationPoint, int[] states) {
        this.currentTarget = this.getDropTarget(controlDescriber.getWidget());
        if (this.currentTarget != null) {
            DNDEventAdapter adapter = this.createDNDEvent(destinationPoint, states, 2004);
            Event e = (Event)adapter.getEvent();
            if (itemDescriber != null) {
                e.item = itemDescriber.getItemWidget();
            }
            this.currentTarget.getControl().forceFocus();
            this.getPlayer().getEvents().sendEvent((Widget)this.currentTarget, (Event)adapter.getEvent());
            this.updateInfo(adapter);
        }
    }

    private void doDragEnter(IWidgetDescriber controlDescriber, IWidgetDescriber itemDescriber, Point destinationPoint, int[] states) {
        this.currentTarget = this.getDropTarget(controlDescriber.getWidget());
        if (this.currentTarget != null) {
            DNDEventAdapter adapter = this.createDNDEvent(destinationPoint, states, 2002);
            Event e = (Event)adapter.getEvent();
            if (itemDescriber != null) {
                e.item = itemDescriber.getItemWidget();
            }
            this.currentTarget.getControl().forceFocus();
            this.getPlayer().getEvents().sendEvent((Widget)this.currentTarget, (Event)adapter.getEvent());
            this.updateInfo(adapter);
        }
    }

    private void doDragLeave(Point destinationPoint, int[] states) {
        if (this.currentTarget != null) {
            DNDEventAdapter adapter = this.createDNDEvent(destinationPoint, states, 2003);
            this.currentTarget.getControl().forceFocus();
            this.getPlayer().getEvents().sendEvent((Widget)this.currentTarget, (Event)adapter.getEvent());
        }
    }

    private void doDragEnd(IWidgetDescriber controlDescriber, Point destinationPoint, int[] states) {
        DragSource source = this.getDragSource(controlDescriber.getWidget());
        DNDEventAdapter adapter = this.createDNDEvent(destinationPoint, states, 2000);
        source.getControl().forceFocus();
        this.getPlayer().getEvents().sendEvent((Widget)source, (Event)adapter.getEvent());
    }

    private void doDragSetData(Widget widget, Point point, int[] states) {
        Transfer transfer;
        int n;
        this.currentSource = this.getDragSource(widget);
        boolean isDataTypeSupported = false;
        if (this.dataType instanceof TransferData) {
            Transfer[] transfers;
            Transfer[] transferArray = transfers = this.currentTarget.getTransfer();
            n = transfers.length;
            int n2 = 0;
            while (n2 < n) {
                transfer = transferArray[n2];
                if (transfer.isSupportedType((TransferData)this.dataType)) {
                    isDataTypeSupported = true;
                    break;
                }
                ++n2;
            }
        }
        if (!isDataTypeSupported && this.currentTarget != null) {
            List<Transfer> fromTransfer = Arrays.asList(this.currentSource.getTransfer());
            Transfer transfer2 = transfer = this.currentTarget.getTransfer();
            int n3 = ((Transfer[])transfer2).length;
            n = 0;
            while (n < n3) {
                Transfer t = transfer2[n];
                if (fromTransfer.contains(t)) {
                    TransferData[] supportedTypes;
                    TransferData[] transferDataArray = supportedTypes = t.getSupportedTypes();
                    if (supportedTypes.length == 0) break;
                    TransferData td = transferDataArray[0];
                    this.dataType = td;
                    break;
                }
                ++n;
            }
        }
        if (this.dataType == null) {
            TeslaCore.log((String)"Failed to locate transfer for D&D ");
        }
        DNDEventAdapter event = this.createDNDEvent(point, states, 2001);
        this.getPlayer().getEvents().sendEvent((Widget)this.currentSource, (Event)event.getEvent());
        Event e = (Event)event.getEvent();
        this.currentData = e.data;
    }

    private void showItemBeforeDrag(IWidgetDescriber itemDescriber) {
        if (itemDescriber.getWidget() instanceof TableItem) {
            TableItem tableItem = (TableItem)itemDescriber.getWidget();
            tableItem.getParent().showItem(tableItem);
        } else if (itemDescriber.getWidget() instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)itemDescriber.getWidget();
            treeItem.getParent().showItem(treeItem);
        }
    }

    private void updateInfo(DNDEventAdapter event) {
        this.dataType = event.getDataType();
        this.feedback = event.getFeedback();
        this.currentItem = ((Event)event.getEvent()).item;
    }

    private DNDEventAdapter createDNDEvent(int kind, Widget widget, Point point, int[] states, Widget item) {
        DNDEventAdapter a = this.createDNDEvent(point, states, kind);
        Event e = (Event)a.getEvent();
        e.widget = widget;
        e.item = item;
        return a;
    }

    private DNDEventAdapter createDNDEvent(Point point, int[] states, int kind) {
        DNDEventAdapter adapter = DNDEventAdapter.createAdapter();
        new EventBuilder((Event)adapter.getEvent()).widget((Widget)this.currentSource).xy(point).type(kind).button(states[1]).stateMask(states[2]).detail(states[0]).doit(true);
        if (this.currentSource != null) {
            Transfer[] transfer = this.currentSource.getTransfer();
            ArrayList<TransferData> resultDatas = new ArrayList<TransferData>();
            Transfer[] transferArray = transfer;
            int n = transfer.length;
            int n2 = 0;
            while (n2 < n) {
                Transfer transfer2 = transferArray[n2];
                resultDatas.addAll(Arrays.asList(transfer2.getSupportedTypes()));
                ++n2;
            }
            adapter.setDataTypes(resultDatas.toArray(new TransferData[resultDatas.size()]));
        }
        adapter.setOperations(states[3]);
        adapter.setDataType(this.dataType);
        adapter.setFeedback(this.feedback);
        return adapter;
    }

    private DropTarget getDropTarget(Widget widget) {
        List targets = DNDManager.getInstance().getTargets();
        for (DropTarget dropTarget : targets) {
            if (!dropTarget.getControl().equals(widget)) continue;
            return dropTarget;
        }
        return this.currentTarget;
    }

    private DragSource getDragSource(Widget widget) {
        List sources = DNDManager.getInstance().getSources();
        for (DragSource dragSource : sources) {
            if (!dragSource.getControl().equals(widget)) continue;
            return dragSource;
        }
        return null;
    }

    private SWTUIPlayer getPlayer() {
        return ((SWTUIProcessor)this.client.getProcessor(SWTUIProcessor.class)).getPlayer();
    }

    private Response reportFailed(String msg) {
        BooleanResponse response = ProtocolFactory.eINSTANCE.createBooleanResponse();
        response.setMessage(msg);
        response.setStatus(ResponseStatus.FAILED);
        return response;
    }
}

