/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rcptt.verifications.status.StatusFactory;
import org.eclipse.rcptt.verifications.status.TreeItemVerificationError;
import org.eclipse.rcptt.verifications.tree.TreeNode;

public abstract class TreeComparison<T> {
    private boolean allowUnmatched;

    public TreeComparison(boolean allowUnmatched) {
        this.allowUnmatched = allowUnmatched;
    }

    public List<TreeItemVerificationError> assertNode(TreeNode<T> expected, TreeNode<T> actual) {
        List<TreeItemVerificationError> res = this.compare(expected.payload(), actual.payload());
        String name = this.getName(expected.payload());
        if (!res.isEmpty()) {
            this.setPath(res, Collections.<Integer>emptyList(), name);
            return res;
        }
        Collection<TreeNode<T>> childrenE = expected.getChildren();
        ArrayList<TreeNode<T>> childrenA = new ArrayList<TreeNode<T>>(actual.getChildren());
        return this.assertChildren(childrenE, childrenA, Collections.<Integer>emptyList(), name);
    }

    private boolean isChildrenCountValid(int expected, int actual) {
        if (expected == actual) {
            return true;
        }
        if (!this.allowUnmatched) {
            return false;
        }
        return actual > expected;
    }

    public List<TreeItemVerificationError> assertChildren(Collection<? extends TreeNode<T>> childrenExpected, Collection<? extends TreeNode<T>> childrenActual, List<Integer> itemIndPath, String fullItemPath) {
        ArrayList<TreeItemVerificationError> rv = new ArrayList<TreeItemVerificationError>();
        if (!this.isChildrenCountValid(childrenExpected.size(), childrenActual.size())) {
            rv.add(this.createError(String.format("Different row children amount, expected %d, but was %d", childrenExpected.size(), childrenActual.size()), itemIndPath, fullItemPath));
        }
        Iterator<TreeNode<T>> actualIter = childrenActual.iterator();
        int i = 0;
        for (TreeNode<T> expectedChild : childrenExpected) {
            List<TreeItemVerificationError> firstDifference = null;
            TreeNode<T> next = null;
            ArrayList<Integer> indPath = new ArrayList<Integer>(itemIndPath.size() + 1);
            indPath.addAll(itemIndPath);
            indPath.add(i);
            String fullPath = String.valueOf(fullItemPath) + "/" + this.getName(expectedChild.payload());
            while (actualIter.hasNext()) {
                next = actualIter.next();
                List<TreeItemVerificationError> childRes = this.compare(expectedChild.payload(), next.payload());
                if (childRes.isEmpty()) {
                    firstDifference = null;
                    break;
                }
                if (firstDifference == null) {
                    firstDifference = childRes;
                }
                if (!this.allowUnmatched) break;
            }
            if (firstDifference != null) {
                this.setPath(firstDifference, indPath, fullPath);
                rv.addAll(firstDifference);
                break;
            }
            if (next == null) {
                rv.add(this.createError(String.format("Expected %s, but no more elements left", this.getName(expectedChild.payload())), indPath, fullPath));
                return rv;
            }
            if (this.isChildrenVerificationRequired(expectedChild.payload())) {
                Collection<TreeNode<T>> exchildren = expectedChild.getChildren();
                rv.addAll(this.assertChildren(exchildren, next.getChildren(), indPath, fullPath));
            }
            ++i;
        }
        return rv;
    }

    public abstract boolean isChildrenVerificationRequired(T var1);

    private void setPath(List<TreeItemVerificationError> data, List<Integer> indPath, String fullPath) {
        for (TreeItemVerificationError error : data) {
            error.getItemIndexPath().addAll(indPath);
            error.setItemPath(fullPath);
        }
    }

    private TreeItemVerificationError createError(String firstDifference, List<Integer> indPath, String fullPath) {
        TreeItemVerificationError error = StatusFactory.eINSTANCE.createTreeItemVerificationError();
        error.setMessage(firstDifference);
        error.getItemIndexPath().addAll(indPath);
        error.setItemPath(fullPath);
        return error;
    }

    public abstract String getName(T var1);

    public abstract List<TreeItemVerificationError> compare(T var1, T var2);
}

