/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDEManager;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractXMLMarkerResolution;
import org.eclipse.pde.internal.ui.nls.ExternalizeStringsOperation;
import org.eclipse.pde.internal.ui.nls.ModelChange;
import org.eclipse.pde.internal.ui.nls.ModelChangeElement;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.text.edits.MalformedTreeException;

public class ExternalizeResolution
extends AbstractXMLMarkerResolution {
    public ExternalizeResolution(int resolutionType, IMarker marker) {
        super(resolutionType, marker);
    }

    /*
     * Loose catch block
     */
    @Override
    protected void createChange(IPluginModelBase model) {
        ModelChange change = new ModelChange(model, true);
        Object node = this.findNode(model);
        ModelChangeElement element = new ModelChangeElement(change, node);
        if (element.updateValue()) {
            String localization = PDEManager.getBundleLocalization((IPluginModelBase)model);
            if (localization == null) {
                localization = "plugin";
                this.addLocalization(model, "plugin");
            }
            IProject project = model.getUnderlyingResource().getProject();
            IFile file = PDEProject.getLocalizationFile((IProject)project);
            this.checkPropertiesFile(file);
            try {
                try {
                    ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                    manager.connect(file.getFullPath(), LocationKind.IFILE, null);
                    ITextFileBuffer buffer = manager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
                    if (buffer.isDirty()) {
                        buffer.commit(null, true);
                    }
                    IDocument document = buffer.getDocument();
                    ExternalizeStringsOperation.getPropertiesInsertEdit(document, element).apply(document);
                    buffer.commit(null, true);
                }
                catch (CoreException e) {
                    PDEPlugin.log(e);
                    try {
                        FileBuffers.getTextFileBufferManager().disconnect(file.getFullPath(), LocationKind.IFILE, null);
                    }
                    catch (CoreException e2) {
                        PDEPlugin.log(e2);
                    }
                }
                catch (MalformedTreeException e) {
                    PDEPlugin.log(e);
                    try {
                        FileBuffers.getTextFileBufferManager().disconnect(file.getFullPath(), LocationKind.IFILE, null);
                    }
                    catch (CoreException e3) {
                        PDEPlugin.log(e3);
                    }
                }
                catch (BadLocationException e) {
                    PDEPlugin.log(e);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        FileBuffers.getTextFileBufferManager().disconnect(file.getFullPath(), LocationKind.IFILE, null);
                    }
                    catch (CoreException e4) {
                        PDEPlugin.log(e4);
                    }
                }
            }
            finally {
                try {
                    FileBuffers.getTextFileBufferManager().disconnect(file.getFullPath(), LocationKind.IFILE, null);
                }
                catch (CoreException e) {
                    PDEPlugin.log(e);
                }
            }
        }
    }

    public String getLabel() {
        if (this.isAttrNode()) {
            return NLS.bind((String)PDEUIMessages.ExternalizeResolution_attrib, (Object)this.getNameOfNode());
        }
        if (this.fLocationPath.charAt(0) == '(') {
            return NLS.bind((String)PDEUIMessages.ExternalizeResolution_text, (Object)this.getNameOfNode());
        }
        return NLS.bind((String)PDEUIMessages.ExternalizeResolution_header, (Object)this.fLocationPath);
    }

    private void addLocalization(IPluginModelBase model, String localizationValue) {
        if (model instanceof IBundlePluginModelBase) {
            IBundle bundle = ((IBundlePluginModelBase)model).getBundleModel().getBundle();
            bundle.setHeader("Bundle-Localization", localizationValue);
        }
    }

    @Override
    public void run(IMarker marker) {
        IFile manifest;
        this.fResource = marker.getResource();
        IFile file = (IFile)marker.getResource();
        ModelModification modification = null;
        if (!file.getName().equals("MANIFEST.MF") && (manifest = PDEProject.getManifest((IProject)file.getProject())).exists()) {
            modification = new ModelModification(manifest, file){

                @Override
                protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                    ExternalizeResolution.this.createChange(model);
                }
            };
        }
        if (modification == null) {
            modification = new ModelModification(file){

                @Override
                protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                    ExternalizeResolution.this.createChange(model);
                }
            };
        }
        PDEModelUtility.modifyModel(modification, null);
    }

    @Override
    public IMarker[] findOtherMarkers(IMarker[] markers) {
        return new IMarker[0];
    }

    private void checkPropertiesFile(IFile file) {
        if (!file.exists()) {
            String propertiesFileComment = ExternalizeStringsOperation.getPropertiesFileComment(file);
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try (ByteArrayInputStream pStream = new ByteArrayInputStream(propertiesFileComment.getBytes());){
                    IContainer container = file.getParent();
                    if (!container.exists()) {
                        CoreUtility.createFolder((IFolder)((IFolder)container));
                    }
                    file.create((InputStream)pStream, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException throwable) {}
        }
    }
}

