/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jetty;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.passage.lic.internal.jetty.JettyRequest;
import org.eclipse.passage.lic.internal.net.api.handle.NetRequest;
import org.eclipse.passage.lic.internal.net.api.handle.NetResponse;

public final class JettyHandler
extends Handler.Abstract {
    private final Function<NetRequest, NetResponse> handler;

    public JettyHandler(Function<NetRequest, NetResponse> handler) {
        Objects.requireNonNull(handler, "JettyHandler::handler");
        this.handler = handler;
    }

    public boolean handle(Request request, Response answer, Callback callback) throws Exception {
        NetResponse response = this.handler.apply(new JettyRequest(request));
        this.write(response, request, answer, callback);
        return true;
    }

    private void write(NetResponse response, Request request, Response answer, Callback callback) throws IOException {
        byte[] payload;
        if (response.failed()) {
            NetResponse.Error error = response.error();
            Response.writeError((Request)request, (Response)answer, (Callback)callback, (int)error.code(), (String)error.message());
            return;
        }
        answer.setStatus(200);
        if (!response.carriesPayload()) {
            callback.succeeded();
            return;
        }
        try {
            payload = response.payload();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        answer.getHeaders().put(HttpHeader.CONTENT_LENGTH, (long)payload.length);
        answer.getHeaders().put(HttpHeader.CONTENT_TYPE, this.contentType(response) + "; charset=UTF-8");
        answer.write(true, ByteBuffer.wrap(payload), callback);
    }

    private String contentType(NetResponse response) {
        return response.contentType().contentType();
    }
}

