/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jetty.interaction;

import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.passage.lic.equinox.access.LicenseProtection;
import org.eclipse.passage.lic.internal.jetty.JettyException;
import org.eclipse.passage.lic.internal.jetty.JettyServer;
import org.eclipse.passage.lic.internal.jetty.interaction.Command;
import org.eclipse.passage.lic.internal.jetty.interaction.Scope;
import org.eclipse.passage.lic.internal.net.connect.BindAddress;
import org.eclipse.passage.lic.internal.net.connect.Port;

final class ServerHandles
extends Command {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final JettyServer server;
    private final LicenseProtection license = new LicenseProtection();
    private final BindAddress listen;
    private final Port port;

    ServerHandles(JettyServer server, String name) {
        super((Scope)new Scope.Of(name), (List<String>)new Handlers().get());
        this.server = server;
        this.listen = new BindAddress("0.0.0.0");
        this.port = new Port(8090);
    }

    public void start() {
        if (!this.license.check()) {
            return;
        }
        try {
            this.server.launch(this.listen, this.port);
        }
        catch (JettyException e) {
            this.log.error("failed to launch Jetty server", (Throwable)e);
        }
    }

    public void stop() {
        this.license.release();
        try {
            this.server.terminate();
        }
        catch (JettyException e) {
            this.log.error("failed to terminate Jetty server", (Throwable)e);
        }
    }

    public void restart() {
        this.stop();
        this.start();
    }

    public void state() {
        try {
            System.out.println(String.valueOf(this.server.state()) + " on " + this.where());
        }
        catch (JettyException e) {
            this.log.error("failed to report state of Jetty server", (Throwable)e);
        }
    }

    private String where() {
        return String.valueOf(this.listen.get().orElse("-")) + ":" + this.port.get().map(i -> i.toString()).orElse("-");
    }

    public ServerHandles(Scope scope, String[] names, JettyServer server, BindAddress listen, Port port) {
        super(scope, names);
        this.server = server;
        this.listen = listen;
        this.port = port;
    }

    @Override
    protected List<String> commands() {
        return new Handlers().get();
    }

    @Override
    public String usage() {
        return "Change ot report running state of the server";
    }

    private static final class Handlers
    extends Command.Name {
        protected Handlers() {
            super(Arrays.asList("start", "stop", "restart", "state"));
        }
    }
}

