/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox.access;

import java.util.Optional;

public interface Interaction {
    public void prompt(String var1);

    public void swear(Throwable var1);

    public String input();

    public static final class Smart
    implements Interaction {
        private final Interaction delegate;

        public Smart(Interaction delegate) {
            this.delegate = delegate;
        }

        void head(String title) {
            this.head(title, Optional.empty());
        }

        void head(String title, String message) {
            this.head(title, Optional.of(message));
        }

        private void head(String title, Optional<String> message) {
            this.delegate.prompt("------------------------------------");
            this.delegate.prompt(String.format("--- %s", title));
            message.ifPresent(this.delegate::prompt);
            this.delegate.prompt("------------------------------------");
        }

        @Override
        public void prompt(String information) {
            this.delegate.prompt(information);
        }

        @Override
        public void swear(Throwable thro) {
            this.delegate.swear(thro);
        }

        @Override
        public String input() {
            return this.delegate.input();
        }
    }
}

