/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jetty;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.passage.lic.internal.jetty.JettyRequest;
import org.eclipse.passage.lic.internal.net.api.handle.NetRequest;
import org.eclipse.passage.lic.internal.net.api.handle.NetResponse;

public final class JettyHandler
extends Handler.Abstract {
    private final Function<NetRequest, NetResponse> handler;

    public JettyHandler(Function<NetRequest, NetResponse> handler) {
        Objects.requireNonNull(handler, "JettyHandler::handler");
        this.handler = handler;
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        response.setStatus(200);
        long contentLength = -1L;
        for (HttpField field : request.getHeaders()) {
            HttpHeader header = field.getHeader();
            if (header == null) continue;
            switch (header) {
                case CONTENT_LENGTH: {
                    response.getHeaders().add(field);
                    contentLength = field.getLongValue();
                    break;
                }
                case CONTENT_TYPE: {
                    response.getHeaders().add(field);
                    break;
                }
                case TRAILER: {
                    response.setTrailersSupplier((Supplier)HttpFields.build());
                    break;
                }
                case TRANSFER_ENCODING: {
                    contentLength = Long.MAX_VALUE;
                }
            }
        }
        if (contentLength > 0L) {
            Content.copy((Content.Source)request, (Content.Sink)response, (Content.Chunk.Processor)Response.newTrailersChunkProcessor((Response)response), (Callback)callback);
        } else {
            callback.succeeded();
        }
        return true;
    }

    private NetResponse response(Request request) {
        return this.handler.apply(new JettyRequest(request));
    }

    private void write(NetResponse response, HttpServletResponse envelope) throws IOException {
        envelope.setContentType(response.contentType().contentType());
        envelope.setCharacterEncoding("UTF-8");
        if (response.failed()) {
            envelope.sendError(response.error().code(), response.error().message());
            return;
        }
        envelope.setStatus(200);
        if (response.carriesPayload()) {
            byte[] payload;
            try {
                payload = response.payload();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            envelope.setContentLength(payload.length);
            Throwable throwable = null;
            Object var5_7 = null;
            try (PrintWriter out = envelope.getWriter();){
                out.write(new String(payload, Charset.forName("UTF-8")));
                out.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            envelope.flushBuffer();
        }
    }
}

