/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.users.ui.handlers;

import java.util.Optional;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.loc.internal.products.ProductRegistry;
import org.eclipse.passage.loc.internal.users.ui.i18n.UsersUiMessages;
import org.eclipse.passage.loc.report.internal.core.user.CustomerExportService;
import org.eclipse.passage.loc.report.internal.core.user.CustomerStorage;
import org.eclipse.passage.loc.report.internal.ui.jface.user.ExposedExportCustomersWizard;
import org.eclipse.swt.widgets.Shell;

public class ExportCustomersHandler {
    @Execute
    public void execute(IEclipseContext context) {
        Optional<ProductRegistry> products = this.service(ProductRegistry.class, context);
        if (!products.isPresent()) {
            return;
        }
        Optional<CustomerStorage> customers = this.service(CustomerStorage.class, context);
        if (!customers.isPresent()) {
            return;
        }
        Optional<CustomerExportService> export = this.service(CustomerExportService.class, context);
        if (!export.isPresent()) {
            return;
        }
        new ExposedExportCustomersWizard(products.get(), customers.get(), export.get()).accept((Shell)context.get(Shell.class));
    }

    private <S> Optional<S> service(Class<S> service, IEclipseContext context) {
        Optional<Object> implementation = Optional.ofNullable(context.get(service));
        if (!implementation.isPresent()) {
            MessageDialog.openError((Shell)((Shell)context.get(Shell.class)), (String)UsersUiMessages.ExportCustomersHandler_unavailableTitle, (String)NLS.bind((String)UsersUiMessages.ExportCustomersHandler_unavailableMessage, (Object)service.getName()));
        }
        return implementation;
    }
}

