/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.ui.jface.user;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.lic.users.UserOriginDescriptor;
import org.eclipse.passage.loc.report.internal.core.user.CustomerStorage;
import org.eclipse.passage.loc.report.internal.ui.i18n.ExportCustomersWizardMessages;
import org.eclipse.passage.loc.report.internal.ui.jface.PageObserver;
import org.eclipse.passage.loc.report.internal.ui.jface.user.DataForExport;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

final class PreviewPage
extends WizardPage
implements PageObserver {
    private final CustomerStorage customers;
    private List users;
    private Text path;
    private final DataForExport data;

    protected PreviewPage(CustomerStorage customers, DataForExport data) {
        super("preview");
        this.customers = customers;
        this.data = data;
        this.setTitle(ExportCustomersWizardMessages.PreviewPage_title);
        this.setMessage(ExportCustomersWizardMessages.PreviewPage_description);
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        this.users = new List(content, 2056);
        this.users.setLayoutData((Object)new GridData(4, 4, true, true));
        this.path = new Text(content, 2056);
        this.path.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.setControl((Control)content);
    }

    @Override
    public void update() {
        this.updateTargetPath();
        this.updateUsers();
        this.getWizard().getContainer().updateButtons();
    }

    private void updateTargetPath() {
        this.path.setText(this.data.target().toString());
    }

    private void updateUsers() {
        this.users.removeAll();
        Set<String> products = this.data.products();
        this.addUsers("Users", storage -> storage.personsUsedProducts(products), this::userInfo);
        this.addUsers("Companies", storage -> storage.companiesUsedProducts(products), this::companyInfo);
    }

    private <T> void addUsers(String title, Function<CustomerStorage, Collection<T>> target, Function<T, String> info) {
        this.users.add(String.format("--- %s ---", title));
        target.apply(this.customers).stream().map(info).sorted().forEach(arg_0 -> ((List)this.users).add(arg_0));
    }

    private String userInfo(UserDescriptor user) {
        return NLS.bind((String)"{0} ({1})", (Object)user.getContact().getName(), (Object)user.getContact().getEmail());
    }

    private String companyInfo(UserOriginDescriptor company) {
        return NLS.bind((String)"{0} ({1})", (Object)company.getName(), (Object)company.getIdentifier());
    }
}

