/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.panel;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.passage.lic.emf.meta.ClassMetadata;
import org.eclipse.passage.lic.emf.meta.ComposableClassMetadata;
import org.eclipse.passage.lic.features.FeatureDescriptor;
import org.eclipse.passage.lic.features.FeatureSetDescriptor;
import org.eclipse.passage.lic.features.FeatureVersionDescriptor;
import org.eclipse.passage.lic.internal.features.model.FeaturesClassMetadata;
import org.eclipse.passage.lic.internal.licenses.model.LicensesClassMetadata;
import org.eclipse.passage.lic.internal.products.model.ProductsClassMetadata;
import org.eclipse.passage.lic.internal.users.model.UsersClassMetadata;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.products.ProductDescriptor;
import org.eclipse.passage.lic.products.ProductLineDescriptor;
import org.eclipse.passage.lic.products.ProductVersionDescriptor;
import org.eclipse.passage.lic.products.ProductVersionFeatureDescriptor;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.lic.users.UserOriginDescriptor;
import org.eclipse.passage.loc.dashboard.ui.panel.DashboardPanelAdvisor;
import org.eclipse.passage.loc.dashboard.ui.panel.DefaultDashboardPanelAdvisor;
import org.eclipse.passage.loc.internal.features.FeatureRegistry;
import org.eclipse.passage.loc.internal.licenses.LicenseRegistry;
import org.eclipse.passage.loc.internal.products.ProductRegistry;
import org.eclipse.passage.loc.internal.users.UserRegistry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class DashboardPanelPart {
    private final FeatureRegistry featureRegistry;
    private final ProductRegistry productRegistry;
    private final UserRegistry userRegistry;
    private final LicenseRegistry licenseRegistry;
    private final DashboardPanelAdvisor dashboardAdvisor;

    @Inject
    public DashboardPanelPart(IEclipseContext context) {
        this.featureRegistry = (FeatureRegistry)context.get(FeatureRegistry.class);
        this.productRegistry = (ProductRegistry)context.get(ProductRegistry.class);
        this.userRegistry = (UserRegistry)context.get(UserRegistry.class);
        this.licenseRegistry = (LicenseRegistry)context.get(LicenseRegistry.class);
        DashboardPanelAdvisor advisor = (DashboardPanelAdvisor)context.get(DashboardPanelAdvisor.class);
        if (advisor == null) {
            advisor = new DefaultDashboardPanelAdvisor();
        }
        this.dashboardAdvisor = advisor;
    }

    @PostConstruct
    public void postConstruct(Composite parent, IEclipseContext context) {
        this.dashboardAdvisor.init(context);
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        area.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        this.createHeaderInfo(area);
        this.createFeatureInfo(area);
        this.createProductInfo(area);
        this.createUserInfo(area);
        this.createLicenseInfo(area);
        this.createFooterInfo(area);
        ComposableClassMetadata metadata = (ComposableClassMetadata)EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(this.getClass()).getBundleContext()).get(ComposableClassMetadata.class);
        metadata.consider((ClassMetadata)new FeaturesClassMetadata());
        metadata.consider((ClassMetadata)new ProductsClassMetadata());
        metadata.consider((ClassMetadata)new UsersClassMetadata());
        metadata.consider((ClassMetadata)new LicensesClassMetadata());
    }

    protected void createHeaderInfo(Composite parent) {
        this.dashboardAdvisor.createHeaderInfo(parent);
    }

    protected void createFeatureInfo(Composite parent) {
        this.dashboardAdvisor.createFeatureInfo(parent, this.featureRegistry);
    }

    protected void createProductInfo(Composite parent) {
        this.dashboardAdvisor.createProductInfo(parent, this.productRegistry);
    }

    protected void createUserInfo(Composite parent) {
        this.dashboardAdvisor.createUserInfo(parent, this.userRegistry);
    }

    protected void createLicenseInfo(Composite parent) {
        this.dashboardAdvisor.createLicenseInfo(parent, this.licenseRegistry);
    }

    protected void createFooterInfo(Composite parent) {
        this.dashboardAdvisor.createFooterInfo(parent);
    }

    @Inject
    @Optional
    public void createdFeatureSet(@UIEventTopic(value="org/eclipse/passage/lic/features/registry/FeatureSet/create") FeatureSetDescriptor input) {
        this.dashboardAdvisor.updateFeatureInfo(this.featureRegistry);
    }

    @Inject
    @Optional
    public void deletedFeatureSet(@UIEventTopic(value="org/eclipse/passage/lic/features/registry/FeatureSet/delete") FeatureSetDescriptor input) {
        this.dashboardAdvisor.updateFeatureInfo(this.featureRegistry);
    }

    @Inject
    @Optional
    public void createdFeature(@UIEventTopic(value="org/eclipse/passage/lic/features/registry/Feature/create") FeatureDescriptor input) {
        this.dashboardAdvisor.updateFeatureInfo(this.featureRegistry);
    }

    @Inject
    @Optional
    public void deletedFeature(@UIEventTopic(value="org/eclipse/passage/lic/features/registry/Feature/delete") FeatureDescriptor input) {
        this.dashboardAdvisor.updateFeatureInfo(this.featureRegistry);
    }

    @Inject
    @Optional
    public void createdFeatureVersion(@UIEventTopic(value="org/eclipse/passage/lic/features/registry/FeatureVersion/create") FeatureVersionDescriptor input) {
        this.dashboardAdvisor.updateFeatureInfo(this.featureRegistry);
    }

    @Inject
    @Optional
    public void deletedFeatureVersion(@UIEventTopic(value="org/eclipse/passage/lic/features/registry/FeatureVersion/delete") FeatureVersionDescriptor input) {
        this.dashboardAdvisor.updateFeatureInfo(this.featureRegistry);
    }

    @Inject
    @Optional
    public void createdProductLine(@UIEventTopic(value="org/eclipse/passage/lic/products/registry/ProductLine/create") ProductLineDescriptor input) {
        this.dashboardAdvisor.updateProductInfo(this.productRegistry);
    }

    @Inject
    @Optional
    public void deletedProductLine(@UIEventTopic(value="org/eclipse/passage/lic/products/registry/ProductLine/delete") ProductLineDescriptor input) {
        this.dashboardAdvisor.updateProductInfo(this.productRegistry);
    }

    @Inject
    @Optional
    public void createdProduct(@UIEventTopic(value="org/eclipse/passage/lic/products/registry/Product/create") ProductDescriptor input) {
        this.dashboardAdvisor.updateProductInfo(this.productRegistry);
    }

    @Inject
    @Optional
    public void deletedProduct(@UIEventTopic(value="org/eclipse/passage/lic/products/registry/Product/delete") ProductDescriptor input) {
        this.dashboardAdvisor.updateProductInfo(this.productRegistry);
    }

    @Inject
    @Optional
    public void createdProductVersion(@UIEventTopic(value="org/eclipse/passage/lic/products/registry/ProductVersion/create") ProductVersionDescriptor input) {
        this.dashboardAdvisor.updateProductInfo(this.productRegistry);
    }

    @Inject
    @Optional
    public void deletedProductVersion(@UIEventTopic(value="org/eclipse/passage/lic/products/registry/ProductVersion/delete") ProductVersionDescriptor input) {
        this.dashboardAdvisor.updateProductInfo(this.productRegistry);
    }

    @Inject
    @Optional
    public void createdProductVersionFeature(@UIEventTopic(value="org/eclipse/passage/lic/products/registry/ProductVersionFeature/create") ProductVersionFeatureDescriptor input) {
        this.dashboardAdvisor.updateProductInfo(this.productRegistry);
    }

    @Inject
    @Optional
    public void deletedProductVersionFeature(@UIEventTopic(value="org/eclipse/passage/lic/products/registry/ProductVersionFeature/delete") ProductVersionFeatureDescriptor input) {
        this.dashboardAdvisor.updateProductInfo(this.productRegistry);
    }

    @Inject
    @Optional
    public void createdUserOrigin(@UIEventTopic(value="org/eclipse/passage/lic/users/registry/UserOrigin/create") UserOriginDescriptor input) {
        this.dashboardAdvisor.updateUserInfo(this.userRegistry);
    }

    @Inject
    @Optional
    public void deletedUserOrigin(@UIEventTopic(value="org/eclipse/passage/lic/users/registry/UserOrigin/delete") UserOriginDescriptor input) {
        this.dashboardAdvisor.updateUserInfo(this.userRegistry);
    }

    @Inject
    @Optional
    public void createdUser(@UIEventTopic(value="org/eclipse/passage/lic/users/registry/User/create") UserDescriptor input) {
        this.dashboardAdvisor.updateUserInfo(this.userRegistry);
    }

    @Inject
    @Optional
    public void deletedUser(@UIEventTopic(value="org/eclipse/passage/lic/users/registry/User/delete") UserDescriptor input) {
        this.dashboardAdvisor.updateUserInfo(this.userRegistry);
    }

    @Inject
    @Optional
    public void createdLicensePlan(@UIEventTopic(value="org/eclipse/passage/lic/licenses/registry/LicensePlan/create") LicensePlanDescriptor input) {
        this.dashboardAdvisor.updateLicenseInfo(this.licenseRegistry);
    }

    @Inject
    @Optional
    public void deletedLicensePlan(@UIEventTopic(value="org/eclipse/passage/lic/licenses/registry/LicensePlan/delete") LicensePlanDescriptor input) {
        this.dashboardAdvisor.updateLicenseInfo(this.licenseRegistry);
    }

    @PreDestroy
    public void preDestroy(IEclipseContext context) {
        this.dashboardAdvisor.dispose(context);
    }

    @Focus
    public void onFocus() {
    }

    @Persist
    public void save() {
    }
}

