/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.DiagnosticDialog;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.EnvironmentStateDialog;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.ImportLicenseDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class GoodIntention {
    public abstract boolean paveTheWay();

    static final class Diagnose
    extends GoodIntention {
        private final Supplier<Shell> shell;
        private final Diagnostic diagnostic;

        Diagnose(Supplier<Shell> shell, Diagnostic diagnostic) {
            this.shell = shell;
            this.diagnostic = diagnostic;
        }

        @Override
        public boolean paveTheWay() {
            new DiagnosticDialog(this.shell.get(), this.diagnostic).open();
            return false;
        }
    }

    static final class ImportLicense
    extends GoodIntention {
        private final Supplier<Shell> shell;

        ImportLicense(Supplier<Shell> shell) {
            this.shell = shell;
        }

        @Override
        public boolean paveTheWay() {
            return new ImportLicenseDialog(this.shell.get()).open() == 0;
        }
    }

    static final class Nope
    extends GoodIntention {
        Nope() {
        }

        @Override
        public boolean paveTheWay() {
            return false;
        }
    }

    static final class RequestLicense
    extends GoodIntention {
        private final Supplier<Shell> shell;

        RequestLicense(Supplier<Shell> shell) {
            this.shell = shell;
        }

        @Override
        public boolean paveTheWay() {
            new EnvironmentStateDialog(this.shell.get()).open();
            return false;
        }
    }
}

