/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.io;

import java.nio.file.Path;
import java.util.function.Supplier;

public abstract class PassageFileExtension
implements Supplier<String> {
    public final boolean ends(Path path) {
        return path.getFileName().toString().endsWith((String)this.get());
    }

    public static final class LicenseDecrypted
    extends PassageFileExtension {
        @Override
        public String get() {
            return ".lic";
        }
    }

    public static final class LicenseEncrypted
    extends PassageFileExtension {
        @Override
        public String get() {
            return ".licen";
        }
    }

    public static final class Of
    extends PassageFileExtension {
        private final Supplier<String> extension;

        public Of(Supplier<String> extension) {
            this.extension = extension;
        }

        @Override
        public String get() {
            return this.extension.get();
        }
    }

    public static final class PrivateKey
    extends PassageFileExtension {
        @Override
        public String get() {
            return ".scr";
        }
    }

    public static final class PublicKey
    extends PassageFileExtension {
        @Override
        public String get() {
            return ".pub";
        }
    }

    public static final class Settings
    extends PassageFileExtension {
        @Override
        public String get() {
            return ".settings";
        }
    }
}

