/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.licenses.migration.tobemoved;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.passage.lic.internal.api.EvaluationInstructions;
import org.eclipse.passage.lic.internal.api.EvaluationType;
import org.eclipse.passage.lic.internal.api.conditions.Condition;
import org.eclipse.passage.lic.internal.api.conditions.MatchingRule;
import org.eclipse.passage.lic.internal.api.conditions.ValidityPeriod;
import org.eclipse.passage.lic.internal.api.conditions.VersionMatch;
import org.eclipse.passage.lic.internal.api.conditions.mining.ConditionTransport;
import org.eclipse.passage.lic.internal.api.conditions.mining.ContentType;
import org.eclipse.passage.lic.internal.base.conditions.BaseCondition;
import org.eclipse.passage.lic.internal.base.conditions.BaseEvaluationInstructions;
import org.eclipse.passage.lic.internal.base.conditions.BaseValidityPeriodClosed;
import org.eclipse.passage.lic.internal.base.conditions.BaseVersionMatch;
import org.eclipse.passage.lic.internal.base.conditions.MatchingRuleDefault;
import org.eclipse.passage.lic.internal.base.conditions.MatchingRuleForIdentifier;
import org.eclipse.passage.lic.internal.licenses.migration.LicensesResourceHandler;
import org.eclipse.passage.lic.licenses.model.api.LicenseGrant;
import org.eclipse.passage.lic.licenses.model.api.LicensePack;

abstract class BaseXmiConditionTransport
implements ConditionTransport {
    private final ContentType type = new ContentType.Xml();
    private final Predicate<LicensePack> filter;

    protected BaseXmiConditionTransport() {
        this(p -> true);
    }

    protected BaseXmiConditionTransport(Predicate<LicensePack> filter) {
        this.filter = filter;
    }

    public ContentType id() {
        return this.type;
    }

    public Collection<Condition> read(InputStream input) throws IOException {
        XMIResourceImpl resource = new XMIResourceImpl();
        resource.load(input, Collections.singletonMap("RESOURCE_HANDLER", new LicensesResourceHandler()));
        return resource.getContents().stream().filter(LicensePack.class::isInstance).map(LicensePack.class::cast).filter(this.filter).map(LicensePack::getLicenseGrants).flatMap(i -> StreamSupport.stream(i.spliterator(), false)).map(this::condition).collect(Collectors.toList());
    }

    private Condition condition(LicenseGrant descriptor) {
        return new BaseCondition(descriptor.getIdentifier(), descriptor.getFeatureIdentifier(), (VersionMatch)new BaseVersionMatch(descriptor.getMatchVersion(), this.rule(descriptor.getMatchRule())), (ValidityPeriod)new BaseValidityPeriodClosed(this.fromDate(descriptor.getValidFrom()), this.fromDate(descriptor.getValidUntil())), (EvaluationInstructions)new BaseEvaluationInstructions((EvaluationType)new EvaluationType.Of(descriptor.getConditionType()), descriptor.getConditionExpression()));
    }

    private MatchingRule rule(String origin) {
        if (origin == null) {
            return new MatchingRuleDefault();
        }
        return new MatchingRuleForIdentifier(origin).get();
    }

    private ZonedDateTime fromDate(Date date) {
        if (date == null) {
            return ZonedDateTime.now().minusMinutes(1L);
        }
        return ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }
}

