/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.internal.api.registry.Registry;
import org.eclipse.passage.lic.internal.api.registry.Service;
import org.eclipse.passage.lic.internal.api.registry.ServiceId;
import org.eclipse.passage.lic.internal.base.i18n.BaseMessages;

public abstract class BaseRegistry<I extends ServiceId, S extends Service<I>>
implements Registry<I, S> {
    protected final Map<I, S> services;

    public BaseRegistry(Collection<S> service) {
        this.services = service.stream().collect(Collectors.toMap(Service::id, Function.identity()));
    }

    public final boolean hasService(I id) {
        return this.services.containsKey(id);
    }

    public final S service(I id) {
        if (!this.hasService(id)) {
            throw new IllegalStateException(String.format(BaseMessages.getString("Registry.retrieve_absent_exception"), id));
        }
        return (S)((Service)this.services.get(id));
    }

    public final Collection<S> services() {
        return new ArrayList<S>(this.services.values());
    }
}

