/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base;

import java.util.Optional;
import org.eclipse.passage.lbc.internal.api.RawRequest;
import org.eclipse.passage.lbc.internal.base.DecodedParam;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.base.BaseLicensedProduct;
import org.eclipse.passage.lic.internal.base.ProductIdentifier;
import org.eclipse.passage.lic.internal.base.ProductVersion;
import org.eclipse.passage.lic.internal.net.LicenseUser;

public final class ProductUserRequest {
    private final RawRequest raw;
    private final Optional<LicensedProduct> product;
    private final Optional<String> user;

    public ProductUserRequest(RawRequest raw) throws LicensingException {
        this.raw = raw;
        this.product = this.extractProduct();
        this.user = this.extractUser();
    }

    private Optional<LicensedProduct> extractProduct() throws LicensingException {
        Optional id = new ProductIdentifier(arg_0 -> ((RawRequest)this.raw).parameter(arg_0)).get();
        Optional version = new ProductVersion(arg_0 -> ((RawRequest)this.raw).parameter(arg_0)).get();
        if (!id.isPresent() || !version.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new BaseLicensedProduct(new DecodedParam((String)id.get()).get(), new DecodedParam((String)version.get()).get()));
    }

    private Optional<String> extractUser() {
        return new LicenseUser(arg_0 -> ((RawRequest)this.raw).parameter(arg_0)).get();
    }

    public RawRequest raw() {
        return this.raw;
    }

    public Optional<LicensedProduct> product() {
        return this.product;
    }

    public Optional<String> user() {
        return this.user;
    }
}

