/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.acquire;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.passage.lbc.internal.api.FloatingResponse;
import org.eclipse.passage.lbc.internal.api.Grants;
import org.eclipse.passage.lbc.internal.base.EObjectTransfer;
import org.eclipse.passage.lbc.internal.base.Failure;
import org.eclipse.passage.lbc.internal.base.PlainSuceess;
import org.eclipse.passage.lbc.internal.base.ProductUserRequest;
import org.eclipse.passage.lic.floating.model.api.GrantAcqisition;
import org.eclipse.passage.lic.floating.model.meta.FloatingPackage;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.conditions.ConditionAction;
import org.eclipse.passage.lic.internal.base.FeatureIdentifier;
import org.eclipse.passage.lic.internal.emf.EObjectFromBytes;

public final class Acquisition {
    private final ProductUserRequest data;
    private final Logger log = LogManager.getLogger(this.getClass());

    public Acquisition(ProductUserRequest data) {
        Objects.requireNonNull(data, "Acquisition::data");
        this.data = data;
    }

    public FloatingResponse get() {
        Optional<GrantAcqisition> acquisition;
        Optional feature = new FeatureIdentifier(key -> this.data.raw().parameter(key)).get();
        if (!feature.isPresent()) {
            return new Failure.BadRequestNoFeature();
        }
        try {
            acquisition = this.acquisition((String)feature.get());
        }
        catch (LicensingException e) {
            this.log.error("failed: ", (Throwable)e);
            return new Failure.OperationFailed(new ConditionAction.Acquire().name(), e.getMessage());
        }
        if (acquisition.isEmpty()) {
            return this.noGrants((String)feature.get());
        }
        return new EObjectTransfer((EObject)acquisition.get());
    }

    public FloatingResponse returnBack() throws LicensingException {
        GrantAcqisition acquisition;
        try {
            acquisition = this.acquisition();
        }
        catch (IOException e) {
            throw new LicensingException((Throwable)e);
        }
        boolean released = this.grants().release(this.data.product().get(), acquisition);
        if (!released) {
            return new Failure.NotReleased(this.data.product().get(), acquisition);
        }
        return new PlainSuceess();
    }

    private Optional<GrantAcqisition> acquisition(String feature) throws LicensingException {
        return this.grants().acquire(this.data.product().get(), this.data.user().get(), feature);
    }

    private GrantAcqisition acquisition() throws LicensingException, IOException {
        return (GrantAcqisition)new EObjectFromBytes(this.data.raw().content(), GrantAcqisition.class).get(Collections.singletonMap("http://www.eclipse.org/passage/lic/floating/0.1.0", FloatingPackage.eINSTANCE));
    }

    private Grants grants() {
        return this.data.raw().state().grants();
    }

    private Failure.NoGrantsAvailable noGrants(String feature) {
        return new Failure.NoGrantsAvailable(this.data.product().get(), feature);
    }
}

