/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.PassageUI;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.internal.base.restrictions.CertificateWorthAttention;
import org.eclipse.passage.lic.internal.equinox.EquinoxPassage;
import org.eclipse.passage.lic.internal.equinox.EquinoxPassageLicenseCoverage;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.DiagnosticDialog;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.LicenseStatusDialog;
import org.eclipse.swt.widgets.Shell;

public final class EquinoxPassageUI
implements PassageUI {
    private final Supplier<Shell> shell;

    public EquinoxPassageUI(Supplier<Shell> shell) {
        this.shell = shell;
    }

    public ServiceInvocationResult<ExaminationCertificate> acquireLicense(String feature) {
        return this.investigate(() -> this.acquire(feature), certificate -> !new CertificateWorthAttention().test(certificate));
    }

    public ServiceInvocationResult<ExaminationCertificate> assessLicensingStatus() {
        return this.investigate(this::assess, c -> false);
    }

    private ServiceInvocationResult<ExaminationCertificate> investigate(Supplier<ServiceInvocationResult<ExaminationCertificate>> gain, Predicate<Optional<ExaminationCertificate>> ok) {
        ServiceInvocationResult<ExaminationCertificate> result = gain.get();
        while (this.exposeAndMayBeEvenFix(result, ok)) {
            result = gain.get();
        }
        return result;
    }

    private ServiceInvocationResult<ExaminationCertificate> acquire(String feature) {
        return new EquinoxPassage().acquireLicense(feature);
    }

    private ServiceInvocationResult<ExaminationCertificate> assess() {
        return new EquinoxPassageLicenseCoverage().assess();
    }

    private boolean exposeAndMayBeEvenFix(ServiceInvocationResult<ExaminationCertificate> result, Predicate<Optional<ExaminationCertificate>> ok) {
        if (!result.data().isPresent()) {
            new DiagnosticDialog(this.shell.get(), result.diagnostic()).open();
            return false;
        }
        if (ok.test(result.data())) {
            return false;
        }
        ExaminationCertificate certificate = (ExaminationCertificate)result.data().get();
        LicenseStatusDialog dialog = new LicenseStatusDialog(this.shell.get(), certificate, result.diagnostic());
        if (dialog.open() != 0) {
            return false;
        }
        return dialog.goodIntention().paveTheWay();
    }
}

