/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.DeleteMessageHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ReplaceMessageHandler;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.HashMap;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class MessageManagerConfig
extends MQMBeanReadWrite {
    private static MBeanParameterInfo[] deleteMessageSignature;
    private static MBeanParameterInfo[] replaceMessageSignature;
    private static MBeanOperationInfo[] ops;

    public void deleteMessage(String destinationType, String destinationName, String messageID) throws MBeanException {
        try {
            if (destinationType == null) {
                throw new BrokerException("Admin deleteMessage: destination type not specified", 400);
            }
            PacketRouter pr = Globals.getPacketRouter(1);
            if (pr == null) {
                throw new BrokerException("Admin deleteMessage: Could not locate Admin Packet Router");
            }
            AdminDataHandler dhd = (AdminDataHandler)pr.getHandler(5);
            DeleteMessageHandler hd = (DeleteMessageHandler)dhd.getHandler(88);
            hd.deleteMessage(messageID, destinationName, destinationType.equals("q"));
        }
        catch (Exception e) {
            int status;
            boolean logstack = true;
            if (e instanceof BrokerException && ((status = ((BrokerException)e).getStatusCode()) == 405 || status == 404 || status == 409 || status == 400)) {
                logstack = false;
            }
            Object[] args = new Object[]{messageID, destinationName, e.getMessage()};
            String emsg = rb.getKString("B4420", args);
            if (logstack) {
                this.logger.logStack(32, emsg, e);
            } else {
                this.logger.log(32, emsg, e);
            }
            this.handleOperationException("deleteMessage", e);
        }
    }

    public String replaceMessage(String destinationType, String destinationName, String messageID, HashMap messageBody) throws MBeanException {
        String newMsgID = null;
        try {
            if (destinationType == null) {
                throw new BrokerException("Admin replaceMessage: destination name and type not specified", 400);
            }
            PacketRouter pr = Globals.getPacketRouter(1);
            if (pr == null) {
                throw new BrokerException("Admin deleteMessage: Could not locate Admin Packet Router");
            }
            AdminDataHandler dhd = (AdminDataHandler)pr.getHandler(5);
            ReplaceMessageHandler hd = (ReplaceMessageHandler)dhd.getHandler(90);
            newMsgID = hd.replaceMessage(messageID, destinationName, messageBody, destinationType.equals("q"));
        }
        catch (Exception e) {
            int status;
            boolean logstack = true;
            if (e instanceof BrokerException && ((status = ((BrokerException)e).getStatusCode()) == 405 || status == 404 || status == 409 || status == 400)) {
                logstack = false;
            }
            Object[] args = new Object[]{messageID, destinationName, e.getMessage()};
            String emsg = rb.getKString("B4420", args);
            if (logstack) {
                this.logger.logStack(32, emsg, e);
            } else {
                this.logger.log(32, emsg, e);
            }
            this.handleOperationException("replaceMessage", e);
        }
        return newMsgID;
    }

    @Override
    public String getMBeanName() {
        return "MessageManagerConfig";
    }

    @Override
    public String getMBeanDescription() {
        return "Configuration MBean for Message Manager";
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return null;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return null;
    }

    static {
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[3];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("destinationType", String.class.getName(), mbr.getString("MB1187"));
        mBeanParameterInfoArray[1] = new MBeanParameterInfo("destinationName", String.class.getName(), mbr.getString("MB1188"));
        mBeanParameterInfoArray[2] = new MBeanParameterInfo("messageID", String.class.getName(), "Message ID");
        deleteMessageSignature = mBeanParameterInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[4];
        mBeanParameterInfoArray2[0] = new MBeanParameterInfo("destinationType", String.class.getName(), mbr.getString("MB1187"));
        mBeanParameterInfoArray2[1] = new MBeanParameterInfo("destinationName", String.class.getName(), mbr.getString("MB1188"));
        mBeanParameterInfoArray2[2] = new MBeanParameterInfo("messageID", String.class.getName(), "Message ID");
        mBeanParameterInfoArray2[3] = new MBeanParameterInfo("messageBody", HashMap.class.getName(), "Message Body");
        replaceMessageSignature = mBeanParameterInfoArray2;
        ops = new MBeanOperationInfo[]{new MBeanOperationInfo("deleteMessage", "Delete a message in a destination", deleteMessageSignature, Void.TYPE.getName(), 1), new MBeanOperationInfo("replaceMessage", "Replace a message in a destination", replaceMessageSignature, String.class.getName(), 1)};
    }
}

