/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver;

import com.sun.messaging.bridge.api.BridgeServiceManager;
import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.BridgeBaseContextAdapter;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.GlobalErrorHandler;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterBroadcast;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.api.NoClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.comm.CommGlobals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.CoreLifecycleImpl;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.data.protocol.Protocol;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.management.mbeans.resources.MBeanResources;
import com.sun.messaging.jmq.jmsserver.memory.MemoryManager;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.api.StoreManager;
import com.sun.messaging.jmq.jmsserver.plugin.spi.CoreLifecycleSpi;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.MetricManager;
import com.sun.messaging.jmq.jmsserver.service.PortMapper;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.tlsutil.KeystoreUtil;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.BrokerShutdownRuntimeException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.MQTimer;
import com.sun.messaging.portunif.PUService;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Properties;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;

public final class Globals
extends CommGlobals {
    public static final String HOSTNAME_ALL = "*";
    private static GlobalErrorHandler errhandler = null;
    private static volatile Globals globals = null;
    private static Protocol protocol = null;
    private static volatile MBeanResources mbr = null;
    private static volatile Version version = null;
    private static volatile PUService puService = null;
    private static volatile PortMapper portMapper = null;
    private static MQAddress mqAddress = null;
    private static ServiceManager serviceManager = null;
    private static ConnectionManager connectionManager = null;
    private static ClusterBroadcast messageBus = null;
    private static Object heartbeatService = null;
    private static MetricManager metricManager = null;
    private static volatile MQTimer timer = null;
    private static volatile Boolean HAEnabled = null;
    private static volatile Boolean useSharedConfigRecord = null;
    private static String clusterID = null;
    private static UID HAStoreSession = new UID(-1L);
    private static UID brokerSession = null;
    private static String brokerID = null;
    private static String hostname = null;
    private static String jmxHostname = null;
    private static BrokerAddress myaddr = null;
    private static InetAddress brokerInetAddress = null;
    private static InetAddress jmxInetAddress = null;
    private static PacketRouter[] routers = null;
    private static volatile MemoryManager mem_manager = null;
    private static boolean useMem = true;
    private static Agent agent = null;
    private static BrokerStateHandler stateHandler = null;
    private static HAMonitorService hasvc = null;
    public static final String INTERNAL_PREFIX = "MQ_";
    private static ClusterManager clusterConfig = null;
    private static volatile CoreLifecycleSpi coreLifecycle = null;
    private static HashMap<String, CoreLifecycleSpi> corePlugins = new HashMap();
    private static BridgeServiceManager bridgeManager = null;
    private static boolean apiDirectTwoThreadSyncReplies = true;
    public static final String KEYSTORE_USE_PASSFILE_PROP = "imq.passfile.enabled";
    public static final String KEYSTORE_PASSDIR_PROP = "imq.passfile.dirpath";
    public static final String KEYSTORE_PASSFILE_PROP = "imq.passfile.name";
    public static final String READ_PROPERTIES_FROM_STDIN = "imq.readstdin.enabled";
    public static final String BROKERID_PROPERTY = "imq.brokerid";
    public static final String JDBCBROKERID_PROPERTY = "imq.persist.jdbc.brokerid";
    public static final String CLUSTERID_PROPERTY = "imq.cluster.clusterid";
    public static final String HA_ENABLED_PROPERTY = "imq.cluster.ha";
    public static final boolean HA_ENABLED_DEFAULT = false;
    public static final String PRIMARY_OWNER_NAME_PROPERTY = "imq.primaryowner.name";
    public static final String PRIMARY_OWNER_CONTACT_PROPERTY = "imq.primaryowner.contact";
    public static final String BROKER_ADMIN_DEFINED_ROLES_PROPERTY_BASE = "imq.broker.adminDefinedRoles";
    public static final String INSTALL_ROOT = "imq.install.root";
    public static final String NOWAIT_MASTERBROKER_PROP = "imq.cluster.nowaitForMasterBroker";
    public static final String DYNAMIC_CHANGE_MASTERBROKER_ENABLED_PROP = "imq.cluster.dynamicChangeMasterBrokerEnabled";
    public static final String NO_MASTERBROKER_PROP = "imq.cluster.nomasterbroker";
    public static final String AUTOCONNECT_CLUSTER_PROPERTY = "imq.cluster.brokerlist";
    public static final String MANUAL_AUTOCONNECT_CLUSTER_PROPERTY = "imq.cluster.brokerlist.manual";
    public static final String AUTOCLUSTER_BROKERMAP_CLASS_PROP = "imq.cluster.autocluster.brokermapclass";
    public static final String PUSERVICE_ENABLED_PROP = "imq.portunif.enabled";
    private static volatile Boolean _logNonTransactedMsgSend = null;
    public static final String LOG_NONTRANSACTEDMSGSEND_PROP = "imq.persist.file.txnLog.nonTransactedMsgSend.enabled";
    private static volatile Boolean _minimizeWritesFileStore = null;
    private static volatile Boolean _minimizePersist = null;
    private static volatile Boolean _minimizePersistLevel2 = null;
    public static final String MINIMIZE_WRITES_FILESTORE_PROP = "imq.persist.file.minimizeWrites";
    public static final String MINIMIZE_PERSIST_PROP = "imq.persist.minimizeWrites";
    public static final String MINIMIZE_PERSIST_LEVEL2_PROP = "imq.persist.minimizeWritesLevel2";
    private static volatile Boolean _deliveryStateNotPersisted = null;
    public static final String DELIVERY_STATE_NOT_PERSITED_PROP = "imq.persist.file.deliveryStateNotPersisted";
    static final String USE_FILELOCK_FOR_LOCKFILE_PROP = "imq.useFileLockForLockFile.enabled";
    private static volatile Boolean useFileLockForLockFile = null;
    private static final String SECURITY_POODLE_FIX_PROP = "imq.poodleFix.enabled";
    private static final String SECURITY_POODLE_FIX_HTTPS_PROP = "imq.protocol.https.poodleFix.enabled";

    public static void cleanup() {
        Globals.cleanupComm();
        clusterConfig = null;
        coreLifecycle = null;
        corePlugins.clear();
        globals = null;
        myaddr = null;
        version = null;
        puService = null;
        portMapper = null;
        mqAddress = null;
        serviceManager = null;
        connectionManager = null;
        messageBus = null;
        heartbeatService = null;
        metricManager = null;
        timer = null;
        HAEnabled = null;
        useSharedConfigRecord = null;
        clusterID = null;
        HAStoreSession = null;
        brokerID = null;
        hostname = null;
        jmxHostname = null;
        brokerInetAddress = null;
        jmxInetAddress = null;
        routers = null;
        mem_manager = null;
        agent = null;
        stateHandler = null;
        bridgeManager = null;
        apiDirectTwoThreadSyncReplies = true;
    }

    private Globals() {
    }

    public static boolean isMasterBrokerSpecified() {
        Properties params = Globals.getParameters();
        if (params == null) {
            return false;
        }
        return params.get("imq.cluster.masterbroker") != null;
    }

    public static void setMemMgrOn(boolean setting) {
        useMem = setting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MemoryManager getMemManager() {
        if (!useMem) {
            return null;
        }
        if (mem_manager == null) {
            Object object = lock;
            synchronized (object) {
                if (mem_manager == null) {
                    mem_manager = new MemoryManager();
                }
            }
        }
        return mem_manager;
    }

    public static void setAgent(Agent ag) {
        agent = ag;
    }

    public static Agent getAgent() {
        return agent;
    }

    public static String getPrimaryOwnerName() {
        return Globals.getConfig().getProperty(PRIMARY_OWNER_NAME_PROPERTY, System.getProperty("user.name"));
    }

    public static String getPrimaryOwnerContact() {
        return Globals.getConfig().getProperty(PRIMARY_OWNER_CONTACT_PROPERTY, System.getProperty("user.name"));
    }

    public static String[] getBrokerAdminDefinedRoles() {
        String countPropName = "imq.broker.adminDefinedRoles.count";
        String countStr = Globals.getConfig().getProperty(countPropName);
        int count = 0;
        if (countStr == null || countStr.equals("")) {
            return Globals.getDefaultBrokerAdminDefinedRoles();
        }
        try {
            count = Integer.parseInt(countStr);
        }
        catch (Exception e) {
            Logger logger = Globals.getLogger();
            logger.log(16, "Invalid value for property " + countPropName + ": " + countStr);
            return Globals.getDefaultBrokerAdminDefinedRoles();
        }
        if (count == 0) {
            return Globals.getDefaultBrokerAdminDefinedRoles();
        }
        String[] ret = new String[count];
        for (int i = 0; i < count; ++i) {
            String propName = "imq.broker.adminDefinedRoles.name" + i;
            ret[i] = Globals.getConfig().getProperty(propName);
        }
        return ret;
    }

    public static String[] getDefaultBrokerAdminDefinedRoles() {
        String[] ret = new String[]{Globals.getConfig().getProperty("imq.instancename")};
        return ret;
    }

    public static void setProtocol(Protocol impl) {
        protocol = impl;
    }

    public static Protocol getProtocol() {
        return protocol;
    }

    public static void setBrokerStateHandler(BrokerStateHandler sh) {
        stateHandler = sh;
    }

    public static BrokerStateHandler getBrokerStateHandler() {
        return stateHandler;
    }

    public static void setHAMonitorService(HAMonitorService sh) {
        hasvc = sh;
    }

    public static HAMonitorService getHAMonitorService() {
        return hasvc;
    }

    public static void setBridgeServiceManager(BridgeServiceManager bm) {
        bridgeManager = bm;
    }

    public static BridgeServiceManager getBridgeServiceManager() {
        return bridgeManager;
    }

    public static boolean bridgeEnabled() {
        return BridgeBaseContextAdapter.bridgeEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Globals getGlobals() {
        if (globals == null) {
            Object object = lock;
            synchronized (object) {
                if (globals == null) {
                    globals = new Globals();
                }
            }
        }
        return globals;
    }

    public static MQTimer getTimer() {
        return Globals.getTimer(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MQTimer getTimer(boolean purge) {
        if (timer == null) {
            Object object = lock;
            synchronized (object) {
                if (timer == null) {
                    timer = new MQTimer(true);
                    MQTimer.setLogger(Globals.getLogger());
                    timer.initUncaughtExceptionHandler();
                }
            }
        }
        if (purge) {
            timer.purge();
        }
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanResources getMBeanResources() {
        if (mbr == null) {
            Object object = lock;
            synchronized (object) {
                if (mbr == null) {
                    mbr = MBeanResources.getResources(Locale.getDefault());
                }
            }
        }
        return mbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getVersion() {
        if (version == null) {
            Object object = lock;
            synchronized (object) {
                if (version == null) {
                    version = new Version(false);
                }
            }
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PUService getPUService() {
        if (puService == null) {
            Object object = lock;
            synchronized (object) {
                if (puService == null) {
                    if (Globals.isPortUnifEnabled() && !Globals.isNucleusManagedBroker()) {
                        try {
                            Class<?> c = Class.forName("com.sun.messaging.portunif.PUService");
                            puService = (PUService)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Exception e) {
                            Globals.getLogger().logStack(32, e.getMessage(), e);
                            Broker.getBroker().exit(-1, "Internal Error: Unable to init PUService. Exiting", BrokerEvent.Type.FATAL_ERROR);
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
            }
        }
        return puService;
    }

    public static boolean isPortUnifEnabled() {
        return Globals.getConfig().getBooleanProperty(PUSERVICE_ENABLED_PROP, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PortMapper getPortMapper() {
        if (portMapper == null) {
            Object object = lock;
            synchronized (object) {
                if (portMapper == null) {
                    portMapper = new PortMapper(Globals.getConfigName());
                    try {
                        portMapper.configure(Globals.getConfig());
                        portMapper.bind();
                    }
                    catch (Exception e) {
                        portMapper = null;
                        Logger logger = Globals.getLogger();
                        if (e instanceof PropertyUpdateException) {
                            logger.log(32, e.getMessage());
                        }
                        logger.logStack(32, e.getMessage(), e);
                    }
                }
            }
        }
        return portMapper;
    }

    public static String getHostname() {
        return hostname;
    }

    public static String getJMXHostname() {
        if (jmxHostname != null) {
            return jmxHostname;
        }
        return Globals.getHostname();
    }

    public static boolean isFileStore() {
        return StoreManager.isConfiguredFileStore();
    }

    public static boolean isJDBCStore() {
        return StoreManager.isConfiguredJDBCStore();
    }

    public static boolean getJDBCHAEnabled() {
        return StoreManager.isConfiguredJDBCStore() && Globals.getHAEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getHAEnabled() {
        if (HAEnabled == null) {
            BrokerConfig conf = Globals.getConfig();
            boolean isHA = conf.getBooleanProperty(HA_ENABLED_PROPERTY, false);
            String clusterID = conf.getProperty(CLUSTERID_PROPERTY);
            Object object = lock;
            synchronized (object) {
                if (HAEnabled == null) {
                    if (isHA) {
                        if (clusterID == null || clusterID.length() == 0) {
                            throw new RuntimeException(Globals.getBrokerResources().getKString("B4253"));
                        }
                        HAEnabled = Boolean.TRUE;
                        Globals.clusterID = clusterID;
                    } else {
                        if (clusterID != null && clusterID.length() != 0) {
                            Globals.clusterID = clusterID;
                        }
                        HAEnabled = Boolean.FALSE;
                    }
                }
            }
        }
        return HAEnabled;
    }

    public static ServiceManager getServiceManager() {
        return serviceManager;
    }

    public static MetricManager getMetricManager() {
        return metricManager;
    }

    public static ConnectionManager getConnectionManager() {
        ConnectionManager cm = connectionManager;
        if (cm != null) {
            return cm;
        }
        throw new BrokerShutdownRuntimeException(Globals.getBrokerResources().getKString("B2298"));
    }

    public static ClusterBroadcast getClusterBroadcast() {
        return messageBus;
    }

    public static void setHostname(String hostname) {
        Globals.hostname = hostname;
    }

    public static void setJMXHostname(String hostname) {
        jmxHostname = hostname;
    }

    public static String getClusterID() {
        return clusterID;
    }

    public static UID getStoreSession() throws BrokerException {
        if (HAStoreSession == null || HAStoreSession.longValue() == -1L) {
            String emsg = "B3044Globals.getStoreSession(): HA store session UID has not been initialized";
            BrokerException be = new BrokerException(emsg);
            Globals.getLogger().logStack(32, emsg, be);
            throw be;
        }
        return HAStoreSession;
    }

    public static void setStoreSession(UID uid) {
        HAStoreSession = uid;
    }

    public static UID getBrokerSessionID() {
        return brokerSession;
    }

    public static String getBrokerID() {
        if (brokerID == null) {
            brokerID = Globals.getConfig().getProperty(BROKERID_PROPERTY, Globals.getConfig().getProperty(JDBCBROKERID_PROPERTY));
        }
        return brokerID;
    }

    public static String getIdentityName() {
        String id = Globals.getBrokerID();
        if (id != null) {
            return id;
        }
        return Globals.getConfigName();
    }

    public static void setServiceManager(ServiceManager sm) {
        serviceManager = sm;
    }

    public static void setMetricManager(MetricManager mm) {
        metricManager = mm;
    }

    public static void setConnectionManager(ConnectionManager cm) {
        connectionManager = cm;
    }

    public static void setClusterBroadcast(ClusterBroadcast mm) {
        messageBus = mm;
    }

    public static void registerHeartbeatService(Object hbs) {
        heartbeatService = hbs;
    }

    public static Object getHeartbeatService() {
        return heartbeatService;
    }

    public static void setMyAddress(BrokerAddress mm) {
        myaddr = mm;
        Globals.setMyAddressObject(mm);
    }

    public static BrokerAddress getMyAddress() {
        return myaddr;
    }

    public static void setBrokerInetAddress(InetAddress ia) {
        brokerInetAddress = ia;
    }

    public static InetAddress getBrokerInetAddress() {
        return brokerInetAddress;
    }

    public static void setJMXInetAddress(InetAddress ia) {
        jmxInetAddress = ia;
    }

    public static InetAddress getJMXInetAddress() {
        if (jmxInetAddress != null) {
            return jmxInetAddress;
        }
        return Globals.getBrokerInetAddress();
    }

    public static String getBrokerHostName() {
        if (hostname != null && !hostname.equals(HOSTNAME_ALL)) {
            return hostname;
        }
        if (brokerInetAddress == null) {
            return null;
        }
        return brokerInetAddress.getCanonicalHostName();
    }

    public static void setGlobalErrorHandler(GlobalErrorHandler handler) {
        errhandler = handler;
    }

    public static void handleGlobalError(Throwable thr, String msg) {
        Globals.handleGlobalError(thr, msg, null);
    }

    static void handleGlobalError(Throwable thr, String msg, Integer exitCode) {
        if (!errhandler.handleGlobalError(thr, msg, exitCode)) {
            logger.logStack(32, "B3100", "received unexpected exception  ", thr);
            Throwable trace = new Throwable();
            trace.fillInStackTrace();
            logger.logStack(4, "Calling stack trace", trace);
        }
    }

    static void setPacketRouters(PacketRouter[] newrouters) {
        routers = newrouters;
    }

    public static PacketRouter getPacketRouter(int type) {
        if (routers == null || type > routers.length) {
            throw new IndexOutOfBoundsException(Globals.getBrokerResources().getKString("B4117", "requested invalid packet router " + type));
        }
        return routers[type];
    }

    public static DestinationList getDestinationList() {
        return Globals.getCoreLifecycle().getDestinationList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoreLifecycleSpi getCoreLifecycle() {
        if (coreLifecycle == null) {
            Object object = lock;
            synchronized (object) {
                if (coreLifecycle == null) {
                    try {
                        coreLifecycle = new CoreLifecycleImpl();
                        if (Globals.getConfig().getBooleanProperty("imq.core.plugin.coherenceMessagePattern.enabled", false)) {
                            Class<?> c = Class.forName("com.sun.messaging.jmq.jmsserver.plugin.impl.msgpattern.MessagePatternCoreLifecycle");
                            CoreLifecycleSpi sub = (CoreLifecycleSpi)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            corePlugins.put(sub.getType(), sub);
                        }
                    }
                    catch (Exception e) {
                        Globals.getLogger().logStack(32, e.getMessage(), e);
                        Broker.getBroker().exit(-1, "Internal Error: Unable to init core lifecycle. Exiting", BrokerEvent.Type.FATAL_ERROR);
                    }
                }
            }
        }
        return coreLifecycle;
    }

    public static CoreLifecycleSpi getCorePlugin(String type) {
        return corePlugins.get(type);
    }

    public static boolean initClusterManager(MQAddress address) throws BrokerException {
        Object object = lock;
        synchronized (object) {
            if (clusterConfig != null) {
                return clusterConfig instanceof NoClusterManager;
            }
            String classname = null;
            if (Globals.getJDBCHAEnabled()) {
                classname = Globals.getConfig().getProperty("imq.hacluster.jdbc.manager.class");
            }
            boolean deft = false;
            String deftclassname = "com.sun.messaging.jmq.jmsserver.cluster.api.NoClusterManager";
            if (classname == null) {
                classname = Globals.getConfig().getProperty("imq.cluster.manager.class");
                deft = true;
            }
            try {
                if (Globals.isNucleusManagedBroker()) {
                    clusterConfig = (ClusterManager)Globals.getHabitat().getService(ClusterManager.class, classname, new Annotation[0]);
                    if (clusterConfig == null && deft) {
                        logger.log(16, "ClassNotFound: " + classname);
                        classname = deftclassname;
                        clusterConfig = (ClusterManager)Globals.getHabitat().getService(ClusterManager.class, classname, new Annotation[0]);
                    }
                    if (clusterConfig == null) {
                        throw new BrokerException("Class " + classname + " not found", 404);
                    }
                } else {
                    Class<?> c = null;
                    try {
                        c = Class.forName(classname);
                    }
                    catch (ClassNotFoundException e) {
                        logger.log(16, e.toString());
                        if (!deft) {
                            throw e;
                        }
                        classname = deftclassname;
                        c = Class.forName(classname);
                    }
                    clusterConfig = (ClusterManager)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                clusterConfig.initialize(address);
                mqAddress = address;
                ClusteredBroker bkr = clusterConfig.getLocalBroker();
                brokerSession = bkr.getBrokerSessionUID();
                return classname.equals(deftclassname);
            }
            catch (Exception ex) {
                if (ex instanceof BrokerException) {
                    throw (BrokerException)ex;
                }
                throw new BrokerException(Globals.getBrokerResources().getKString("B3198"), ex);
            }
        }
    }

    public static ClusterManager getClusterManager() {
        return clusterConfig;
    }

    public static Store getStore() throws BrokerException {
        return StoreManager.getStore();
    }

    public static void releaseStore() {
        StoreManager.releaseStore(true);
    }

    public static void setMQAddress(MQAddress addr) {
        ClusterManager c = Globals.getClusterManager();
        try {
            c.setMQAddress(addr);
        }
        catch (Exception ex) {
            logger.logStack(32, "B3100", "Received bad address " + addr + " ignoring", (Throwable)ex);
            return;
        }
        mqAddress = addr;
    }

    public static MQAddress getMQAddress() {
        return mqAddress;
    }

    public static boolean nowaitForMasterBroker() {
        return Globals.getConfig().getBooleanProperty(NOWAIT_MASTERBROKER_PROP, false);
    }

    public static boolean dynamicChangeMasterBrokerEnabled() {
        return Globals.getConfig().getBooleanProperty(DYNAMIC_CHANGE_MASTERBROKER_ENABLED_PROP, false);
    }

    public static boolean useMasterBroker() {
        if (Globals.getHAEnabled()) {
            return false;
        }
        if (Globals.useSharedConfigRecord()) {
            return false;
        }
        return Globals.getClusterManager().getMasterBroker() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean useSharedConfigRecord() {
        if (useSharedConfigRecord == null) {
            Object object = lock;
            synchronized (object) {
                if (useSharedConfigRecord == null) {
                    if (Globals.getHAEnabled()) {
                        useSharedConfigRecord = Boolean.FALSE;
                    } else {
                        boolean nomb = Globals.getConfig().getBooleanProperty(NO_MASTERBROKER_PROP, false);
                        if (nomb) {
                            if (Globals.getClusterID() == null) {
                                throw new RuntimeException(Globals.getBrokerResources().getKString("B4317", CLUSTERID_PROPERTY, "imq.cluster.nomasterbroker=true"));
                            }
                            useSharedConfigRecord = Boolean.TRUE;
                        } else {
                            useSharedConfigRecord = Boolean.FALSE;
                        }
                    }
                }
            }
        }
        return useSharedConfigRecord;
    }

    public static boolean isConfigForCluster() {
        return Globals.getHAEnabled() || Globals.getConfig().getProperty(AUTOCONNECT_CLUSTER_PROPERTY) != null || Globals.getConfig().getProperty(MANUAL_AUTOCONNECT_CLUSTER_PROPERTY) != null;
    }

    public static boolean txnLogEnabled() {
        return StoreManager.txnLogEnabled();
    }

    public static boolean isNewTxnLogEnabled() {
        return StoreManager.newTxnLogEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean logNonTransactedMsgSend() {
        if (_logNonTransactedMsgSend == null) {
            Object object = lock;
            synchronized (object) {
                if (_logNonTransactedMsgSend == null) {
                    _logNonTransactedMsgSend = Globals.txnLogEnabled() && Globals.getConfig().getBooleanProperty(LOG_NONTRANSACTEDMSGSEND_PROP);
                }
            }
        }
        return _logNonTransactedMsgSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMinimumWritesFileStore() {
        if (_minimizeWritesFileStore == null) {
            Object object = lock;
            synchronized (object) {
                if (_minimizeWritesFileStore == null) {
                    _minimizeWritesFileStore = Globals.getConfig().getBooleanProperty(MINIMIZE_WRITES_FILESTORE_PROP, false);
                    Globals.getLogger().log(8, "imq.persist.file.minimizeWrites=" + _minimizeWritesFileStore);
                }
            }
        }
        return _minimizeWritesFileStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMinimumPersist() {
        if (_minimizePersist == null) {
            Object object = lock;
            synchronized (object) {
                if (_minimizePersist == null) {
                    _minimizePersist = Globals.getConfig().getBooleanProperty(MINIMIZE_PERSIST_PROP, true);
                    Globals.getLogger().log(8, "imq.persist.minimizeWrites=" + _minimizePersist);
                }
            }
        }
        if (Globals.isFileStore() && Globals.isMinimumWritesFileStore()) {
            return true;
        }
        return _minimizePersist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMinimumPersistLevel2() {
        if (_minimizePersistLevel2 == null) {
            Object object = lock;
            synchronized (object) {
                if (_minimizePersistLevel2 == null) {
                    _minimizePersistLevel2 = Globals.getConfig().getBooleanProperty(MINIMIZE_PERSIST_LEVEL2_PROP, true);
                    if ((Globals.isNewTxnLogEnabled() || !Globals.isJDBCStore()) && _minimizePersistLevel2.booleanValue()) {
                        Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B2219", "imq.persist.minimizeWritesLevel2=" + _minimizePersistLevel2));
                        _minimizePersistLevel2 = Boolean.FALSE;
                    } else {
                        Globals.getLogger().log(8, "imq.persist.minimizeWritesLevel2=" + _minimizePersistLevel2);
                    }
                }
            }
        }
        return _minimizePersistLevel2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDeliveryStateNotPersisted() {
        if (_deliveryStateNotPersisted == null) {
            Object object = lock;
            synchronized (object) {
                if (_deliveryStateNotPersisted == null) {
                    _deliveryStateNotPersisted = Globals.getConfig().getBooleanProperty(DELIVERY_STATE_NOT_PERSITED_PROP);
                }
            }
        }
        return _deliveryStateNotPersisted;
    }

    public static boolean isReadPropertiessFromStdin() {
        return Globals.getConfig().getBooleanProperty(READ_PROPERTIES_FROM_STDIN);
    }

    public static void setAPIDirectTwoThreadSyncReplies(boolean v) {
        apiDirectTwoThreadSyncReplies = v;
    }

    public static boolean getAPIDirectTwoThreadSyncReplies() {
        return apiDirectTwoThreadSyncReplies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getUseFileLockForLockFile() {
        if (useFileLockForLockFile == null) {
            Object object = lock;
            synchronized (object) {
                if (useFileLockForLockFile == null) {
                    useFileLockForLockFile = Globals.getConfig().getBooleanProperty(USE_FILELOCK_FOR_LOCKFILE_PROP, true);
                }
            }
        }
        return useFileLockForLockFile;
    }

    public static boolean getPoodleFixEnabled() {
        return Globals.getConfig().getBooleanProperty(SECURITY_POODLE_FIX_PROP, true);
    }

    public static boolean getPoodleFixHTTPSEnabled() {
        boolean b = Globals.getConfig().getBooleanProperty(SECURITY_POODLE_FIX_PROP, true);
        return Globals.getConfig().getBooleanProperty(SECURITY_POODLE_FIX_HTTPS_PROP, b);
    }

    public static void applyPoodleFix(Object socket, String caller) {
        SSLServerSocket ssock = null;
        SSLSocket sock = null;
        if (socket instanceof SSLServerSocket) {
            ssock = (SSLServerSocket)socket;
        } else {
            sock = (SSLSocket)socket;
        }
        Object[] protocols = ssock != null ? ssock.getEnabledProtocols() : sock.getEnabledProtocols();
        String orig = Arrays.toString(protocols);
        LinkedHashSet<Object> set = new LinkedHashSet<Object>();
        for (Object s : protocols) {
            if (((String)s).equals("SSLv3") || ssock == null && ((String)s).equals("SSLv2Hello")) continue;
            set.add(s);
        }
        Globals.getLogger().log(8, "[" + caller + "]: [" + orig + "], setEnabledProtocols[" + set + "]");
        if (ssock != null) {
            ssock.setEnabledProtocols(set.toArray(new String[set.size()]));
        } else {
            sock.setEnabledProtocols(set.toArray(new String[set.size()]));
        }
    }

    public static String[] getKnownSSLEnabledProtocols(String caller) {
        return KeystoreUtil.getKnownSSLEnabledProtocols(caller);
    }
}

