/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.LinkedHashSet;
import java.util.Objects;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.ui.IWorkingSetUpdater2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.AbstractWorkingSet;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkingSetManager;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.registry.WorkingSetDescriptor;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;

public class WorkingSet
extends AbstractWorkingSet {
    private static final String DEFAULT_ID = "org.eclipse.ui.resourceWorkingSetPage";
    private String editPageId;

    public WorkingSet(String name, String label, IAdaptable[] elements) {
        super(name, label);
        this.internalSetElements(elements);
    }

    protected WorkingSet(String name, String label, IMemento memento) {
        super(name, label);
        String uniqueId;
        this.workingSetMemento = memento;
        if (this.workingSetMemento != null && (uniqueId = this.workingSetMemento.getString("id")) != null) {
            this.setUniqueId(uniqueId);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof WorkingSet) {
            WorkingSet workingSet = (WorkingSet)object;
            return Objects.equals(workingSet.getName(), this.getName()) && Objects.equals(workingSet.getId(), this.getId()) && Objects.equals(workingSet.getElementsArray(), this.getElementsArray());
        }
        return false;
    }

    public String toString() {
        return "WS [name=" + this.getName() + ", elements=" + String.valueOf(this.getElementsArray()) + ", id=" + this.getId() + "]";
    }

    @Override
    public boolean isEditable() {
        WorkingSetDescriptor descriptor = this.getDescriptor(null);
        return descriptor != null && descriptor.isEditable();
    }

    @Override
    public String getId() {
        return this.editPageId;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        WorkingSetDescriptor descriptor = this.getDescriptor(DEFAULT_ID);
        if (descriptor == null) {
            return null;
        }
        return descriptor.getIcon();
    }

    public int hashCode() {
        int hashCode = this.getName().hashCode();
        if (this.editPageId != null) {
            hashCode &= this.editPageId.hashCode();
        }
        return hashCode;
    }

    @Override
    void restoreWorkingSet() {
        IWorkingSetUpdater2 updater = this.getUpdater();
        IAdaptable[] itemsArray = updater != null && updater.isManagingPersistenceOf(this) ? updater.restore(this) : this.restoreFromMemento();
        this.internalSetElements(itemsArray);
    }

    private IAdaptable[] restoreFromMemento() {
        IMemento[] itemMementos = this.workingSetMemento.getChildren("item");
        final LinkedHashSet items = new LinkedHashSet();
        IMemento[] iMementoArray = itemMementos;
        int n = itemMementos.length;
        int n2 = 0;
        while (n2 < n) {
            final IMemento itemMemento = iMementoArray[n2];
            final String factoryID = itemMemento.getString("factoryID");
            if (factoryID == null) {
                WorkbenchPlugin.log("Unable to restore working set item - no factory ID.");
            } else {
                final IElementFactory factory = PlatformUI.getWorkbench().getElementFactory(factoryID);
                if (factory == null) {
                    WorkbenchPlugin.log("Unable to restore working set item - cannot instantiate factory: " + factoryID);
                } else {
                    SafeRunner.run((ISafeRunnable)new SafeRunnable("Unable to restore working set item - exception while invoking factory: " + factoryID){

                        public void run() throws Exception {
                            IAdaptable item = factory.createElement(itemMemento);
                            if (item == null) {
                                if (Policy.DEBUG_WORKING_SETS) {
                                    WorkbenchPlugin.log("Unable to restore working set item - cannot instantiate item: " + factoryID);
                                }
                            } else {
                                items.add(item);
                            }
                        }
                    });
                }
            }
            ++n2;
        }
        return items.toArray(new IAdaptable[items.size()]);
    }

    @Override
    public void saveState(IMemento memento) {
        if (this.workingSetMemento != null) {
            memento.putMemento(this.workingSetMemento);
        } else {
            memento.putString("name", this.getName());
            memento.putString("label", this.getLabel());
            memento.putString("id", this.getUniqueId());
            memento.putString("editPageId", this.editPageId);
            IWorkingSetUpdater2 updater = this.getUpdater();
            if (updater != null && updater.isManagingPersistenceOf(this)) {
                return;
            }
            for (IAdaptable adaptable : this.elements) {
                final IPersistableElement persistable = (IPersistableElement)Adapters.adapt((Object)adaptable, IPersistableElement.class);
                if (persistable == null) continue;
                final IMemento itemMemento = memento.createChild("item");
                itemMemento.putString("factoryID", persistable.getFactoryId());
                SafeRunner.run((ISafeRunnable)new SafeRunnable("Problems occurred while saving persistable item state"){

                    public void run() throws Exception {
                        persistable.saveState(itemMemento);
                    }
                });
            }
        }
    }

    @Override
    public void setElements(IAdaptable[] newElements) {
        AbstractWorkingSet oldWorkingSet = this.clone();
        this.internalSetElements(newElements);
        this.fireWorkingSetChanged("workingSetContentChange", oldWorkingSet);
    }

    @Override
    public void setId(String pageId) {
        this.editPageId = pageId;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isSelfUpdating() {
        WorkingSetDescriptor descriptor = this.getDescriptor(null);
        return descriptor != null && descriptor.getUpdaterClassName() != null;
    }

    @Override
    public boolean isAggregateWorkingSet() {
        return false;
    }

    private WorkingSetDescriptor getDescriptor(String defaultId) {
        WorkingSetRegistry registry = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
        String id = this.getId();
        if (id == null) {
            id = defaultId;
        }
        if (id == null) {
            return null;
        }
        return registry.getWorkingSetDescriptor(id);
    }

    @Override
    public IAdaptable[] adaptElements(IAdaptable[] objects) {
        WorkingSetManager manager = this.getWorkingSetManager();
        if (manager != null) {
            WorkingSetDescriptor descriptor = this.getDescriptor();
            if (descriptor == null || !descriptor.isElementAdapterClassLoaded()) {
                return objects;
            }
            return manager.getElementAdapter(descriptor).adaptElements(this, objects);
        }
        return objects;
    }

    private WorkingSetManager getWorkingSetManager() {
        IWorkingSetManager manager = this.getManager();
        if (manager instanceof WorkingSetManager) {
            return (WorkingSetManager)manager;
        }
        return null;
    }

    private WorkingSetDescriptor getDescriptor() {
        return this.getDescriptor(null);
    }

    private IWorkingSetUpdater2 getUpdater() {
        IWorkingSetUpdater updater;
        WorkingSetDescriptor descriptor;
        WorkingSetManager manager = this.getWorkingSetManager();
        if (manager != null && (descriptor = this.getDescriptor()) != null && (updater = manager.getUpdater(descriptor)) instanceof IWorkingSetUpdater2) {
            return (IWorkingSetUpdater2)updater;
        }
        return null;
    }
}

