/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class BackgroundProgressPart
extends ProgressMonitorPart {
    private final Updater updater = new Updater();

    public BackgroundProgressPart(Composite parent, Layout layout) {
        super(parent, layout);
    }

    public BackgroundProgressPart(Composite parent, Layout layout, int progressIndicatorHeight) {
        super(parent, layout, progressIndicatorHeight);
    }

    public BackgroundProgressPart(Composite parent, Layout layout, boolean createStopButton) {
        super(parent, layout, createStopButton);
    }

    public void beginTask(final String name, final int totalWork) {
        this.updater.update(new Runnable(){

            public void run() {
                BackgroundProgressPart.super.beginTask(name, totalWork);
            }
        });
    }

    public void setTaskName(final String name) {
        this.updater.update(new Runnable(){

            public void run() {
                BackgroundProgressPart.super.setTaskName(name);
            }
        });
    }

    public void subTask(final String name) {
        this.updater.update(new Runnable(){

            public void run() {
                BackgroundProgressPart.super.subTask(name);
            }
        });
    }

    public void done() {
        this.updater.update(new Runnable(){

            public void run() {
                BackgroundProgressPart.super.done();
            }
        });
    }

    public void internalWorked(final double work) {
        this.updater.update(new Runnable(){

            public void run() {
                BackgroundProgressPart.super.internalWorked(work);
            }
        });
    }

    public void worked(final int work) {
        this.updater.update(new Runnable(){

            public void run() {
                BackgroundProgressPart.super.worked(work);
            }
        });
    }

    private static class Updater
    implements Runnable {
        private List<Runnable> runnables;

        private Updater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List<Runnable> currentRunnables;
            Updater updater = this;
            synchronized (updater) {
                currentRunnables = this.runnables;
                this.runnables = null;
            }
            for (Runnable runnable : currentRunnables) {
                runnable.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(Runnable runnable) {
            boolean dispatch;
            Updater updater = this;
            synchronized (updater) {
                if (this.runnables == null) {
                    this.runnables = new ArrayList<Runnable>();
                    dispatch = true;
                } else {
                    dispatch = false;
                }
                this.runnables.add(runnable);
            }
            if (dispatch) {
                UIUtil.asyncExec(this);
            }
        }
    }
}

