/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg.keybox;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.gpg.keybox.Blob;
import org.bouncycastle.gpg.keybox.BlobType;
import org.bouncycastle.gpg.keybox.BlobVerifier;
import org.bouncycastle.gpg.keybox.KeyBlob;
import org.bouncycastle.gpg.keybox.KeyBoxByteBuffer;
import org.bouncycastle.gpg.keybox.KeyInformation;
import org.bouncycastle.gpg.keybox.UserID;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublicKeyRingBlob
extends KeyBlob {
    private final KeyFingerPrintCalculator fingerPrintCalculator;

    private PublicKeyRingBlob(int n, long l, BlobType blobType, int n2, int n3, int n4, List<KeyInformation> list, byte[] byArray, int n5, List<UserID> list2, int n6, List<Long> list3, int n7, int n8, long l2, long l3, long l4, byte[] byArray2, byte[] byArray3, byte[] byArray4, KeyFingerPrintCalculator keyFingerPrintCalculator) {
        super(n, l, blobType, n2, n3, n4, list, byArray, n5, list2, n6, list3, n7, n8, l2, l3, l4, byArray2, byArray3, byArray4);
        this.fingerPrintCalculator = keyFingerPrintCalculator;
    }

    static Blob parseContent(int n, long l, BlobType blobType, int n2, KeyBoxByteBuffer keyBoxByteBuffer, KeyFingerPrintCalculator keyFingerPrintCalculator, BlobVerifier blobVerifier) throws IOException {
        int n3;
        int n4;
        int n5;
        PublicKeyRingBlob.verifyDigest(n, l, keyBoxByteBuffer, blobVerifier);
        int n6 = keyBoxByteBuffer.u16();
        long l2 = keyBoxByteBuffer.u32();
        long l3 = keyBoxByteBuffer.u32();
        int n7 = keyBoxByteBuffer.u16();
        int n8 = keyBoxByteBuffer.u16();
        ArrayList<KeyInformation> arrayList = new ArrayList<KeyInformation>();
        for (n5 = n7 - 1; n5 >= 0; --n5) {
            arrayList.add(KeyInformation.getInstance(keyBoxByteBuffer, n8, n));
        }
        n5 = keyBoxByteBuffer.u16();
        byte[] byArray = keyBoxByteBuffer.bN(n5);
        int n9 = keyBoxByteBuffer.u16();
        keyBoxByteBuffer.u16();
        ArrayList<UserID> arrayList2 = new ArrayList<UserID>();
        for (n4 = n9 - 1; n4 >= 0; --n4) {
            arrayList2.add(UserID.getInstance(keyBoxByteBuffer, n));
        }
        n4 = keyBoxByteBuffer.u16();
        keyBoxByteBuffer.u16();
        ArrayList<Long> arrayList3 = new ArrayList<Long>();
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            arrayList3.add(keyBoxByteBuffer.u32());
        }
        n3 = keyBoxByteBuffer.u8();
        int n10 = keyBoxByteBuffer.u8();
        keyBoxByteBuffer.u16();
        long l4 = keyBoxByteBuffer.u32();
        long l5 = keyBoxByteBuffer.u32();
        long l6 = keyBoxByteBuffer.u32();
        long l7 = keyBoxByteBuffer.u32();
        if (l7 > (long)keyBoxByteBuffer.remaining()) {
            throw new IllegalStateException("sizeOfReservedSpace exceeds content remaining in buffer");
        }
        byte[] byArray2 = keyBoxByteBuffer.bN((int)l7);
        byte[] byArray3 = keyBoxByteBuffer.rangeOf((int)((long)n + l2), (int)((long)n + l2 + l3));
        int n11 = (int)(l - (long)(keyBoxByteBuffer.position() - n) - 20L);
        byte[] byArray4 = keyBoxByteBuffer.bN(n11);
        byte[] byArray5 = keyBoxByteBuffer.rangeOf((int)((long)n + l - 20L), (int)((long)n + l));
        keyBoxByteBuffer.consume(byArray5.length);
        return new PublicKeyRingBlob(n, l, blobType, n2, n6, n7, arrayList, byArray, n9, arrayList2, n4, arrayList3, n3, n10, l4, l5, l6, byArray3, byArray2, byArray5, keyFingerPrintCalculator);
    }

    public PGPPublicKeyRing getPGPPublicKeyRing() throws IOException {
        if (this.type == BlobType.OPEN_PGP_BLOB) {
            return new PGPPublicKeyRing(this.getKeyBytes(), this.fingerPrintCalculator);
        }
        throw new IllegalStateException("Blob is not PGP blob, it is " + this.type.name());
    }
}

