/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.AbstractObservableSet;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementSet;
import org.eclipse.jface.viewers.IElementComparer;

public class ObservableViewerElementSet<E>
extends AbstractObservableSet<E> {
    private Set<E> wrappedSet;
    private Object elementType;
    private IElementComparer comparer;

    public ObservableViewerElementSet(Realm realm, Object elementType, IElementComparer comparer) {
        super(realm);
        Assert.isNotNull((Object)comparer);
        this.wrappedSet = new ViewerElementSet(comparer);
        this.elementType = elementType;
        this.comparer = comparer;
    }

    protected Set<E> getWrappedSet() {
        return this.wrappedSet;
    }

    public Object getElementType() {
        return this.elementType;
    }

    public Iterator<E> iterator() {
        this.getterCalled();
        final Iterator<E> wrappedIterator = this.wrappedSet.iterator();
        return new Iterator<E>(){
            E last;

            @Override
            public boolean hasNext() {
                ObservableViewerElementSet.this.getterCalled();
                return wrappedIterator.hasNext();
            }

            @Override
            public E next() {
                ObservableViewerElementSet.this.getterCalled();
                this.last = wrappedIterator.next();
                return this.last;
            }

            @Override
            public void remove() {
                ObservableViewerElementSet.this.getterCalled();
                wrappedIterator.remove();
                ObservableViewerElementSet.this.fireSetChange(Diffs.createSetDiff(Collections.emptySet(), Collections.singleton(this.last)));
            }
        };
    }

    public boolean add(E o) {
        this.getterCalled();
        boolean changed = this.wrappedSet.add(o);
        if (changed) {
            this.fireSetChange(Diffs.createSetDiff(Collections.singleton(o), Collections.emptySet()));
        }
        return changed;
    }

    public boolean addAll(Collection<? extends E> c) {
        boolean changed;
        this.getterCalled();
        ViewerElementSet<E> additions = new ViewerElementSet<E>(this.comparer);
        for (E element : c) {
            if (!this.wrappedSet.add(element)) continue;
            additions.add(element);
        }
        boolean bl = changed = !additions.isEmpty();
        if (changed) {
            this.fireSetChange(Diffs.createSetDiff(additions, Collections.emptySet()));
        }
        return changed;
    }

    public boolean remove(Object o) {
        this.getterCalled();
        boolean changed = this.wrappedSet.remove(o);
        if (changed) {
            this.fireSetChange(Diffs.createSetDiff(Collections.emptySet(), Collections.singleton(o)));
        }
        return changed;
    }

    public boolean removeAll(Collection<?> c) {
        boolean changed;
        this.getterCalled();
        ViewerElementSet removals = new ViewerElementSet(this.comparer);
        for (Object e : c) {
            Object element = e;
            if (!this.wrappedSet.remove(element)) continue;
            removals.add(element);
        }
        boolean bl = changed = !removals.isEmpty();
        if (changed) {
            this.fireSetChange(Diffs.createSetDiff(Collections.emptySet(), removals));
        }
        return changed;
    }

    public boolean retainAll(Collection<?> c) {
        boolean changed;
        this.getterCalled();
        ViewerElementSet<E> removals = new ViewerElementSet<E>(this.comparer);
        Object[] toRetain = c.toArray();
        Iterator<E> iterator = this.wrappedSet.iterator();
        block0: while (iterator.hasNext()) {
            E element = iterator.next();
            Object[] objectArray = toRetain;
            int n = toRetain.length;
            int n2 = 0;
            while (n2 < n) {
                Object toRet = objectArray[n2];
                if (this.comparer.equals(element, toRet)) continue block0;
                ++n2;
            }
            iterator.remove();
            removals.add(element);
        }
        boolean bl = changed = !removals.isEmpty();
        if (changed) {
            this.fireSetChange(Diffs.createSetDiff(Collections.emptySet(), removals));
        }
        return changed;
    }

    public void clear() {
        this.getterCalled();
        if (!this.wrappedSet.isEmpty()) {
            Set<E> removals = this.wrappedSet;
            this.wrappedSet = new ViewerElementSet(this.comparer);
            this.fireSetChange(Diffs.createSetDiff(Collections.emptySet(), removals));
        }
    }

    public static <E> IObservableSet<E> withComparer(Realm realm, Object elementType, IElementComparer comparer) {
        if (comparer == null) {
            return new WritableSet(realm, Collections.emptySet(), elementType);
        }
        return new ObservableViewerElementSet<E>(realm, elementType, comparer);
    }
}

