/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.internal.oauth.ui;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class LoginDialog
extends TrayDialog {
    private static final boolean DEBUG = Boolean.getBoolean("org.eclipse.userstorage.session.debug");
    private String title;
    private URI startURI;
    private URI stopURI;
    private Browser browser;
    private String instructions;
    private URI finalURI;
    private LocationListener locationListener = new LocationAdapter(){

        public void changing(LocationEvent event) {
            try {
                LoginDialog.debug("Visiting: " + event.location);
                URI next = new URI(event.location);
                if (LoginDialog.this.isStopURI(next)) {
                    event.doit = false;
                    LoginDialog.this.finalURI = new URI(event.location);
                    LoginDialog.this.doClose(0);
                } else if (LoginDialog.this.isValidURI(next)) {
                    event.doit = true;
                } else {
                    event.doit = false;
                    ErrorDialog.openError((Shell)LoginDialog.this.getShell(), (String)"OAuth Flow Error", (String)("The remote directed to an invalid URL: " + event.location), null);
                }
            }
            catch (URISyntaxException ex) {
                ErrorDialog.openError((Shell)LoginDialog.this.getShell(), (String)"OAuth Error", (String)("The remote directed to an invalid URL: " + event.location), null);
            }
        }
    };

    private static void debug(String message) {
        if (DEBUG) {
            System.out.println("<LoginDialog> " + message);
        }
    }

    public LoginDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void doClose(int rc) {
        this.setReturnCode(rc);
        Shell shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                LoginDialog.this.close();
            }
        });
    }

    protected boolean isValidURI(URI next) {
        return true;
    }

    protected boolean isStopURI(URI next) {
        return next.toASCIIString().startsWith(this.getStopURI().toASCIIString());
    }

    public URI getFinalURI() {
        return this.finalURI;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.title != null) {
            newShell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        String instructions = this.getInstructions();
        if (instructions != null && !instructions.isEmpty()) {
            Label message = new Label(composite, 0);
            message.setText(instructions);
        }
        this.browser = new Browser(composite, 2048);
        this.browser.addLocationListener(this.locationListener);
        this.browser.setUrl(this.getStartURI().toASCIIString());
        GridDataFactory.fillDefaults().grab(true, true).hint(800, 600).applyTo((Control)this.browser);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void setTitle(String dialogTitle) {
        this.title = dialogTitle;
    }

    public URI getStartURI() {
        return this.startURI;
    }

    public void setStartURI(URI uri) {
        this.startURI = uri;
    }

    public URI getStopURI() {
        return this.stopURI;
    }

    public void setStopURI(URI uri) {
        this.stopURI = uri;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public String getTitle() {
        return this.title;
    }
}

