/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.completion;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.console.completion.CommandLineParser;
import org.eclipse.equinox.console.completion.common.Completer;

public class FileNamesCompleter
implements Completer {
    private static final String FILE = "file:";

    @Override
    public Map<String, Integer> getCandidates(String buffer, int cursor) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        String currentToken = CommandLineParser.getCurrentToken(buffer, cursor);
        if (currentToken == null || currentToken.equals("")) {
            return new HashMap<String, Integer>();
        }
        if (currentToken.contains(FILE)) {
            String fileName = currentToken.substring(currentToken.indexOf(FILE));
            try {
                URL url = new URL(fileName);
                String canonicalFileName = url.getPath();
                File file = new File(canonicalFileName);
                File parent = file.getParentFile();
                if (file.isDirectory() && canonicalFileName.endsWith("/") || parent == null) {
                    return this.checkChildren(file, "", cursor, false);
                }
                return this.checkChildren(parent, file.getName(), cursor, false);
            }
            catch (MalformedURLException malformedURLException) {
                return result;
            }
        }
        if (currentToken.equals("\\\\") || currentToken.equals("/")) {
            File file = new File(".");
            return this.checkChildren(file, "", cursor, false);
        }
        if (currentToken.contains("\\\\") || currentToken.contains("/")) {
            File file = new File(currentToken);
            File parent = file.getParentFile();
            if (file.isDirectory() && (currentToken.endsWith("/") || currentToken.endsWith("\\\\")) || parent == null) {
                return this.checkChildren(file, "", cursor, false);
            }
            return this.checkChildren(parent, file.getName(), cursor, false);
        }
        return this.checkChildren(new File("."), currentToken, cursor, false);
    }

    private Map<String, Integer> checkChildren(File parent, String nameToComplete, int cursor, boolean absolute) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (parent.exists()) {
            File[] children;
            File[] fileArray = children = parent.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.getName().startsWith(nameToComplete)) {
                    if (absolute) {
                        result.put(child.getAbsolutePath(), cursor - nameToComplete.length());
                    } else {
                        result.put(child.getName(), cursor - nameToComplete.length());
                    }
                }
                ++n2;
            }
        }
        return result;
    }
}

