/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;

public class SwitchToWindowMenu
extends ContributionItem {
    private static final int MAX_TEXT_LENGTH = 40;
    private IWorkbenchWindow workbenchWindow;
    private boolean showSeparator;

    public SwitchToWindowMenu(IWorkbenchWindow window, String id, boolean showSeparator) {
        super(id);
        this.workbenchWindow = window;
        this.showSeparator = showSeparator;
    }

    private String calcText(int number, IWorkbenchWindow window) {
        String suffix = window.getShell().getText();
        if (suffix == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (number < 10) {
            sb.append('&');
        }
        sb.append(number);
        sb.append(' ');
        if (suffix.length() <= 40) {
            sb.append(suffix);
        } else {
            sb.append(suffix.substring(0, 40));
            sb.append("...");
        }
        return sb.toString();
    }

    public void fill(Menu menu, int index) {
        IWorkbench workbench = this.workbenchWindow.getWorkbench();
        IWorkbenchWindow[] array = workbench.getWorkbenchWindows();
        if (array.length < 2) {
            return;
        }
        if (this.showSeparator) {
            new MenuItem(menu, 2, index);
            ++index;
        }
        int count = 1;
        IWorkbenchWindow[] iWorkbenchWindowArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            if (!window.getShell().isDisposed() && (name = this.calcText(count, window)) != null) {
                MenuItem mi = new MenuItem(menu, 16, index);
                ++index;
                ++count;
                mi.setText(name);
                mi.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                    Shell windowShell = window.getShell();
                    if (windowShell.getMinimized()) {
                        windowShell.setMinimized(false);
                    }
                    windowShell.setActive();
                    windowShell.moveAbove(null);
                }));
                mi.setSelection(window == this.workbenchWindow);
            }
            ++n2;
        }
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isDynamic() {
        return true;
    }

    public void dispose() {
        this.workbenchWindow = null;
        super.dispose();
    }
}

