/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.restarts;

import org.sat4j.minisat.core.CircularBuffer;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.SolverStats;

public class Glucose21Restarts
implements RestartStrategy {
    private static final long serialVersionUID = 1L;
    private final CircularBuffer bufferLBD = new CircularBuffer(50);
    private final CircularBuffer bufferTrail = new CircularBuffer(5000);
    private long sumOfAllLBD = 0L;
    private SolverStats stats;

    public void reset() {
        this.sumOfAllLBD = 0L;
        this.bufferLBD.clear();
        this.bufferTrail.clear();
    }

    public void newConflict() {
    }

    public void newLearnedClause(Constr learned, int trailLevel) {
        int lbd = (int)learned.getActivity();
        this.bufferLBD.push(lbd);
        this.sumOfAllLBD += (long)lbd;
        this.bufferTrail.push(trailLevel);
        if (this.stats.conflicts > 10000L && this.bufferTrail.isFull() && (long)trailLevel * 5L > 7L * this.bufferTrail.average()) {
            this.bufferLBD.clear();
        }
    }

    public void init(SearchParams params, SolverStats stats) {
        this.stats = stats;
        this.reset();
    }

    public long nextRestartNumberOfConflict() {
        return 0L;
    }

    public boolean shouldRestart() {
        return this.bufferLBD.isFull() && this.bufferLBD.average() * this.stats.conflicts * 4L > this.sumOfAllLBD * 5L;
    }

    public void onRestart() {
        this.bufferLBD.clear();
    }

    public void onBackjumpToRootLevel() {
    }

    public String toString() {
        return "Glucose 2.1 dynamic restart strategy";
    }
}

