/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.ui.AbstractSetupDialog;
import org.eclipse.oomph.setup.ui.EnablementComposite;
import org.eclipse.oomph.setup.ui.Messages;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.ui.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnablementDialog
extends AbstractSetupDialog {
    private final String productLabel;
    private final Map<EClass, EList<SetupTask>> enablementTasks;
    private EnablementComposite enablementComposite;
    private Button okButton;
    private Button cancelButton;

    public EnablementDialog(Shell parentShell, String productLabel, Map<EClass, EList<SetupTask>> enablementTasks) {
        super(parentShell, Messages.EnablementDialog_title, 600, 400, SetupUIPlugin.INSTANCE, false);
        this.productLabel = productLabel;
        this.enablementTasks = enablementTasks;
    }

    protected String getShellText() {
        return Messages.EnablementDialog_title;
    }

    protected String getDefaultMessage() {
        return EnablementDialog.getDescription(this.productLabel, Messages.EnablementDialog_buttonLabel);
    }

    protected int getContainerMargin() {
        return 10;
    }

    protected void createUI(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.enablementComposite = new EnablementComposite(parent, 2048);
        this.enablementComposite.setLayoutData(new GridData(1808));
        this.enablementComposite.setInput(this.enablementTasks);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, Messages.EnablementDialog_buttonLabel, true);
        this.cancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.enableButtons(false);
        this.enablementComposite.install(new EnablementComposite.InstallHandler(){

            public void installSucceeded() {
                EnablementDialog.this.enableButtons(true);
                EnablementDialog.super.okPressed();
            }

            public void installFailed(Throwable t) {
                ErrorDialog.open((Throwable)t);
                this.installCanceled();
            }

            public void installCanceled() {
                EnablementDialog.this.enableButtons(true);
            }
        });
    }

    private void enableButtons(boolean enabled) {
        this.okButton.setEnabled(enabled);
        this.cancelButton.setEnabled(enabled);
    }

    public static String getDescription(String productLabel, String buttonLabel) {
        return NLS.bind((String)Messages.EnablementDialog_description, (Object[])new Object[]{productLabel, buttonLabel, productLabel});
    }
}

