/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.maven.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemStyledLabelProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.StyledString;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.maven.MavenPackage;
import org.eclipse.oomph.maven.Property;
import org.eclipse.oomph.maven.PropertyReference;
import org.eclipse.oomph.maven.provider.DOMElementItemProvider;

public class PropertyReferenceItemProvider
extends DOMElementItemProvider {
    AdapterFactoryItemDelegator itemDelegator = new AdapterFactoryItemDelegator(this.getAdapterFactory());

    public PropertyReferenceItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addNamePropertyDescriptor(object);
            this.addResolvedPropertyPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PropertyReference_name_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PropertyReference_name_feature", "_UI_PropertyReference_type"), (EStructuralFeature)MavenPackage.Literals.PROPERTY_REFERENCE__NAME, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addResolvedPropertyPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PropertyReference_resolvedProperty_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PropertyReference_resolvedProperty_feature", "_UI_PropertyReference_type"), (EStructuralFeature)MavenPackage.Literals.PROPERTY_REFERENCE__RESOLVED_PROPERTY, false, false, true, null, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/PropertyReference"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        return this.getStyledText(object).getString();
    }

    public StyledString getStyledText(Object object) {
        PropertyReference propertyReference = (PropertyReference)object;
        Property resolvedProperty = propertyReference.getResolvedProperty();
        if (resolvedProperty != null) {
            IItemStyledLabelProvider itemLabelProvider = (IItemStyledLabelProvider)this.adapterFactory.adapt((Notifier)resolvedProperty, IItemStyledLabelProvider.class);
            return (StyledString)itemLabelProvider.getStyledText((Object)resolvedProperty);
        }
        String label = propertyReference.getName();
        StyledString styledLabel = new StyledString();
        if (label == null || label.length() == 0) {
            styledLabel.append(this.getString("_UI_PropertyReference_type"), StyledString.Style.QUALIFIER_STYLER);
        } else {
            styledLabel.append(this.getString("_UI_PropertyReference_type"), StyledString.Style.QUALIFIER_STYLER).append(" " + label);
        }
        return styledLabel;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(PropertyReference.class)) {
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

