/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.processors.pgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.processors.pgp.PGPSignatureVerifier;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;

public class PGPPublicKeyStore {
    private final Map<String, PGPPublicKey> keys = new LinkedHashMap<String, PGPPublicKey>();

    public PGPPublicKey addKey(PGPPublicKey key) {
        if (key == null) {
            return null;
        }
        PGPPublicKey alreadyStoredKey = this.keys.putIfAbsent(PGPPublicKeyService.toHexFingerprint((PGPPublicKey)key), key);
        return alreadyStoredKey == null ? key : alreadyStoredKey;
    }

    public Collection<PGPPublicKey> getKeys(long id) {
        return this.keys.values().stream().filter(key -> key.getKeyID() == id).collect(Collectors.toList());
    }

    public void addKeys(String ... armoredPublicKeys) {
        String[] stringArray = armoredPublicKeys;
        int n = armoredPublicKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String armoredKey = stringArray[n2];
            if (armoredKey != null) {
                PGPPublicKeyStore.readPublicKeys(armoredKey).forEach(this::addKey);
            }
            ++n2;
        }
    }

    public void clear() {
        this.keys.clear();
    }

    public Collection<PGPPublicKey> all() {
        return Collections.unmodifiableCollection(this.keys.values());
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    public String toArmoredString() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArmoredOutputStream armoredOut = new ArmoredOutputStream((OutputStream)out);
        for (PGPPublicKey key : this.all()) {
            key.encode((OutputStream)armoredOut);
        }
        armoredOut.close();
        out.close();
        return new String(out.toByteArray(), StandardCharsets.US_ASCII);
    }

    public void remove(PGPPublicKey selectedKey) {
        this.keys.remove(PGPPublicKeyService.toHexFingerprint((PGPPublicKey)selectedKey));
    }

    public void add(File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream stream = new FileInputStream(file);){
                PGPPublicKeyStore.readPublicKeys(stream).forEach(this::addKey);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", "Could not read PGP key from " + String.valueOf(file), (Throwable)e));
        }
    }

    public static Set<PGPPublicKey> readPublicKeys(InputStream input) throws IOException {
        return PGPPublicKeyStore.readPublicKeys(new String(input.readAllBytes(), StandardCharsets.US_ASCII));
    }

    public static Set<PGPPublicKey> readPublicKeys(String armoredPublicKeyring) {
        if (armoredPublicKeyring == null) {
            return Set.of();
        }
        HashSet<PGPPublicKey> res = new HashSet<PGPPublicKey>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream stream = PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(PGPSignatureVerifier.unnormalizedPGPProperty(armoredPublicKeyring).getBytes(StandardCharsets.US_ASCII)));){
                new JcaPGPObjectFactory(stream).forEach(o -> {
                    if (o instanceof PGPPublicKeyRingCollection) {
                        PGPPublicKeyStore.collectKeys((PGPPublicKeyRingCollection)o, res::add);
                    }
                    if (o instanceof PGPPublicKeyRing) {
                        PGPPublicKeyStore.collectKeys((PGPPublicKeyRing)o, res::add);
                    }
                    if (o instanceof PGPPublicKey) {
                        res.add((PGPPublicKey)o);
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | PGPRuntimeOperationException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", e.getMessage(), e));
        }
        return res;
    }

    private static void collectKeys(PGPPublicKeyRingCollection pgpPublicKeyRingCollection, Consumer<PGPPublicKey> collector) {
        pgpPublicKeyRingCollection.forEach(keyring -> PGPPublicKeyStore.collectKeys(keyring, collector));
    }

    private static void collectKeys(PGPPublicKeyRing pgpPublicKeyRing, Consumer<PGPPublicKey> collector) {
        pgpPublicKeyRing.getPublicKeys().forEachRemaining(collector::accept);
    }
}

