/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.preferences.WorkbenchSettingsTransfer;

public class PreferencesSettingsTransfer
extends WorkbenchSettingsTransfer {
    @Override
    public IStatus transferSettings(IPath newWorkspaceRoot) {
        File srcFolder = new File(this.getOldPath().toOSString());
        File destFolder = new File(this.getNewPath(newWorkspaceRoot).toOSString());
        if (!destFolder.exists()) {
            destFolder.mkdirs();
        }
        if (srcFolder.isDirectory()) {
            String[] files = srcFolder.list();
            if (files == null) {
                return new Status(4, "org.eclipse.ui", "Content from directory '" + srcFolder.getAbsolutePath() + "' can not be listed.");
            }
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File srcFile = new File(srcFolder.getPath(), file);
                File destFile = new File(destFolder.getPath(), file);
                try {
                    this.copyFiles(srcFile, destFile);
                }
                catch (IOException e) {
                    return new Status(4, "org.eclipse.ui", e.getMessage());
                }
                ++n2;
            }
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyFiles(File src, File dest) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            FileOutputStream fos = new FileOutputStream(dest);
            try {
                try (FileInputStream fis = new FileInputStream(src);){
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = fis.read(buffer)) > 0) {
                        fos.write(buffer, 0, length);
                    }
                }
                if (fos == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            fos.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Override
    public String getName() {
        return WorkbenchMessages.WorkbenchPreferences_Name;
    }

    private IPath getNewPath(IPath newWorkspaceRoot) {
        return newWorkspaceRoot.append((IPath)new Path(".metadata/.plugins/org.eclipse.core.runtime/.settings"));
    }

    private IPath getOldPath() {
        return Platform.getLocation().append((IPath)new Path(".metadata/.plugins/org.eclipse.core.runtime/.settings"));
    }
}

